/*
 * Decompiled with CFR 0.152.
 */
package decider.core;

import decider.core.Decider;
import decider.core.Operation;
import decider.core.ProcessArray;

public class Condition
extends Operation {
    private static final long serialVersionUID = 1L;
    private Operation yesOperation;
    private Operation noOperation;
    private int valueIndex;
    private float valueThresh;
    private int yesDecisionCount = 0;

    public Condition(Decider d) {
        super(d);
    }

    @Override
    protected void process() {
        super.process();
        if ((float)this.decider.state[this.valueIndex] > this.valueThresh) {
            this.yesOperation.process();
            ++this.yesDecisionCount;
        } else {
            this.noOperation.process();
        }
    }

    public static Condition newRandom(Decider d, int index, int depth, float splitProb) {
        Condition c = new Condition(d);
        int nextIndex = index;
        if (d.rng.nextFloat() < 0.2f) {
            ++nextIndex;
        }
        c.yesOperation = d.rng.nextFloat() < splitProb * (float)depth ? ProcessArray.newRandom(d) : Condition.newRandom(d, nextIndex, depth + 1, splitProb);
        c.noOperation = d.rng.nextFloat() < splitProb * (float)depth ? ProcessArray.newRandom(d) : Condition.newRandom(d, nextIndex, depth + 1, splitProb);
        c.valueIndex = index < 2 ? 0 : (index - 2) % d.state.length;
        c.valueThresh = (float)(d.numStates / 2 + d.rng.nextInt((int)((float)d.numStates * 0.3f))) - (float)d.numStates * 0.15f;
        return c;
    }

    public static Condition newRandom(Decider d, int index, Operation yesOperation, Operation noOperation) {
        Condition c = new Condition(d);
        c.yesOperation = yesOperation;
        c.noOperation = noOperation;
        c.valueIndex = index < 2 ? 0 : (index - 2) % d.state.length;
        c.valueThresh = (float)(d.numStates / 2 + d.rng.nextInt((int)((float)d.numStates * 0.3f))) - (float)d.numStates * 0.15f;
        return c;
    }

    @Override
    protected void adapt() {
        if (this.usageCount - this.decider.lastConsolidateTime > 0) {
            float yesRatio = (float)(this.yesDecisionCount - this.decider.lastConsolidateTime) / (float)(this.usageCount - this.decider.lastConsolidateTime);
            if ((double)yesRatio < 0.1 || (double)yesRatio > 0.9) {
                if (this.decider.verbose) {
                    System.out.println("consolidating condition " + this.yesDecisionCount + " " + this.usageCount);
                }
                if ((double)this.decider.rng.nextFloat() < 0.3) {
                    this.valueThresh = this.mutateValueThresh();
                }
            } else if (this.decider.verbose) {
                System.out.println("not consolidating condition " + this.yesDecisionCount + " " + this.usageCount);
            }
            this.yesOperation.adapt();
            this.noOperation.adapt();
        } else if (this.decider.verbose) {
            System.out.println("no usage");
        }
    }

    public Operation getYesOperation() {
        return this.yesOperation;
    }

    public Operation getNoOperation() {
        return this.noOperation;
    }

    @Override
    protected void resetCounts() {
        super.resetCounts();
        this.yesOperation.resetCounts();
        this.noOperation.resetCounts();
        this.yesDecisionCount = 0;
    }

    @Override
    protected Operation copyMutate(Decider newDecider) {
        Condition copy = new Condition(newDecider);
        copy.noOperation = this.noOperation.copyMutate(newDecider);
        copy.yesOperation = this.yesOperation.copyMutate(newDecider);
        copy.valueIndex = this.mutateValueIndex();
        copy.valueThresh = this.mutateValueThresh();
        return copy;
    }

    @Override
    protected Operation copy(Decider newDecider) {
        Condition copy = new Condition(newDecider);
        copy.noOperation = this.noOperation.copy(newDecider);
        copy.yesOperation = this.yesOperation.copy(newDecider);
        copy.valueIndex = this.valueIndex;
        copy.valueThresh = this.valueThresh;
        return copy;
    }

    private float mutateValueThresh() {
        float width = this.decider.numStates / 100;
        float newValueThresh = this.valueThresh + (float)this.decider.rng.nextGaussian() * width;
        if (newValueThresh < 0.0f) {
            newValueThresh = 0.0f;
        } else if (newValueThresh >= (float)this.decider.numStates) {
            newValueThresh = this.decider.numStates - 1;
        }
        return newValueThresh;
    }

    private int mutateValueIndex() {
        return this.decider.rng.nextInt(this.decider.state.length);
    }
}

