/*
 * Decompiled with CFR 0.152.
 */
package decider.core;

import decider.core.Condition;
import decider.core.Operation;
import decider.core.ProcessArray;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;

public class Decider
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_NUM_ELEMENTS = 20;
    public static final int DEFAULT_NUM_STATES = 1000000;
    public static final int DEFAULT_CONSOLIDATE_INTERVAL = 100;
    Random rng;
    int numElements;
    int numStates;
    int consolidateInterval;
    boolean doConsolidate;
    boolean verbose;
    boolean doAnalysis;
    int usageCount;
    int lastConsolidateTime;
    int[] state;
    int[] stateChangeCount;
    int[] stateInfluenceCount;
    int numInputs;
    Operation root;
    ArrayList<Integer> sourceIndices;
    ArrayList<Integer> targetIndices;
    int nextLeafIndex;
    int lastLeaf;

    public Decider() {
        this(new Random());
    }

    private Decider(Random rng) {
        this(rng, 20, 1000000, 100, 0);
    }

    private Decider(Random rng, int numElements, int numStates, int consolidateInterval, int numInputs) {
        this.rng = rng;
        this.numElements = numElements;
        this.numStates = numStates;
        this.consolidateInterval = consolidateInterval;
        this.numInputs = numInputs;
        this.nextLeafIndex = 0;
        this.verbose = false;
        this.doConsolidate = true;
        this.doAnalysis = true;
        this.state = new int[numElements];
        this.stateChangeCount = new int[numElements];
        this.stateInfluenceCount = new int[numElements];
        this.usageCount = 0;
        this.sourceIndices = new ArrayList();
        this.targetIndices = new ArrayList();
    }

    public Random getRng() {
        return this.rng;
    }

    public void setNumInputs(int numInputs) {
        this.numInputs = numInputs;
    }

    public void setConsolidate(boolean cons) {
        this.doConsolidate = cons;
    }

    public boolean isConsolidate() {
        return this.doConsolidate;
    }

    public Operation getRoot() {
        return this.root;
    }

    public boolean prob(float prob) {
        return this.rng.nextFloat() < prob;
    }

    public void printState() {
        int i = 0;
        while (i < this.state.length) {
            System.out.print(String.valueOf(this.state[i]) + " ");
            ++i;
        }
        System.out.println();
    }

    public static Decider newRandomTree(int numInputs, int numElements, Random rng, float splitProb) {
        Decider d = new Decider(rng, numElements, 1000000, 100, numInputs);
        d.root = Condition.newRandom(d, 0, 1, splitProb);
        return d;
    }

    public static Decider newRandomStub(int numInputs, int numElements, Random rng) {
        Decider d = new Decider(rng, numElements, 1000000, 100, numInputs);
        d.setNumInputs(numInputs);
        d.root = ProcessArray.newRandom(d);
        return d;
    }

    public void randomiseState() {
        int i = 0;
        while (i < this.state.length) {
            this.state[i] = this.rng.nextInt(this.numStates);
            ++i;
        }
    }

    public void centerState() {
        int i = 0;
        while (i < this.state.length) {
            this.state[i] = this.numStates / 2;
            ++i;
        }
    }

    public void process() {
        this.root.process();
        ++this.usageCount;
        if (this.usageCount % this.consolidateInterval == 0) {
            if (this.doConsolidate) {
                this.adapt();
            }
            this.resetCounts();
            this.lastConsolidateTime = this.usageCount;
        }
        if (this.doAnalysis) {
            this.analysis();
        }
    }

    private void analysis() {
        int[] inputs = new int[this.numInputs];
        int i = 0;
        while (i < this.numInputs) {
            inputs[i] = this.getInputInt(i);
            ++i;
        }
        int result = this.getCurrentLeaf();
        int r1 = result % 10;
        int r2 = result / 10 % 10;
    }

    private void adapt() {
        this.root.adapt();
    }

    private void resetCounts() {
        int i = 0;
        while (i < this.numElements) {
            this.stateChangeCount[i] = 0;
            this.stateInfluenceCount[i] = 0;
            ++i;
        }
        this.usageCount = 0;
        this.root.resetCounts();
    }

    int nextRandomSourceIndex() {
        if (this.sourceIndices.size() == 0) {
            int i = 0;
            while (i < this.numElements) {
                this.sourceIndices.add(i);
                ++i;
            }
        }
        int result = this.sourceIndices.get(this.rng.nextInt(this.sourceIndices.size()));
        this.sourceIndices.remove(new Integer(result));
        return result;
    }

    int nextRandomTargetIndex() {
        if (this.targetIndices.size() == 0) {
            int i = this.numInputs;
            while (i < this.numElements) {
                this.targetIndices.add(i);
                ++i;
            }
        }
        int result = this.targetIndices.get(this.rng.nextInt(this.targetIndices.size()));
        this.targetIndices.remove(new Integer(result));
        return result;
    }

    public float getStateFract(int i) {
        if (i + this.numInputs < this.numElements) {
            return (float)this.state[i + this.numInputs] / (float)this.numStates;
        }
        throw new ArrayIndexOutOfBoundsException(i);
    }

    public float getInputFract(int i) {
        if (i < this.numInputs) {
            return (float)this.state[i] / (float)this.numStates;
        }
        throw new ArrayIndexOutOfBoundsException(i);
    }

    public int getInputInt(int i) {
        if (i < this.numInputs) {
            return this.state[i];
        }
        throw new ArrayIndexOutOfBoundsException(i);
    }

    public void setInputFract(int i, float val) {
        if (i < this.numInputs) {
            val = Math.min(Math.max(val, 0.0f), 1.0f);
            this.state[i] = (int)(val * (float)this.numStates);
        }
    }

    public boolean consolidateModeOn() {
        return this.doConsolidate;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public int getNumHiddenElements() {
        return this.numElements - this.numInputs;
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getConsolidateInterval() {
        return this.consolidateInterval;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public int randomIndex() {
        return this.rng.nextInt(this.numElements);
    }

    public int getCurrentLeaf() {
        return this.lastLeaf;
    }

    public Decider copyMutate() {
        Decider newD = new Decider(this.rng, this.numElements, this.numStates, this.consolidateInterval, this.numInputs);
        newD.root = this.root.copyMutate(newD);
        newD.randomiseState();
        return newD;
    }

    public int getNumLeaves() {
        return this.nextLeafIndex;
    }

    public static Decider read(String filename) {
        Decider d = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            d = (Decider)ois.readObject();
            fis.close();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }
}

