/*
 * Decompiled with CFR 0.152.
 */
package decider.core;

import decider.core.Decider;
import java.io.Serializable;

public abstract class Operation
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Decider decider;
    protected int usageCount;

    public Operation(Decider d) {
        this.decider = d;
        this.usageCount = 0;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    protected void process() {
        ++this.usageCount;
    }

    protected void resetCounts() {
        this.usageCount = 0;
    }

    protected void adapt() {
    }

    protected abstract Operation copyMutate(Decider var1);

    protected abstract Operation copy(Decider var1);

    public int getRecentUsageCount() {
        return this.usageCount - this.decider.lastConsolidateTime;
    }
}

