/*
 * Decompiled with CFR 0.152.
 */
package decider.core;

import decider.core.Decider;
import decider.core.Operation;
import java.io.Serializable;

public class Process
extends Operation {
    private static final long serialVersionUID = 1L;
    static float scale = 0.01f;
    BinaryOp op;
    int sourceIndex;
    int targetIndex;

    public Process(Decider d) {
        super(d);
    }

    private float op(int deciderState) {
        return scale * (float)deciderState;
    }

    @Override
    protected void process() {
        super.process();
        switch (this.op) {
            case ADD: {
                int n = this.targetIndex;
                this.decider.state[n] = (int)((float)this.decider.state[n] + this.op(this.decider.state[this.sourceIndex]));
                break;
            }
            case SUBTRACT: {
                int n = this.targetIndex;
                this.decider.state[n] = (int)((float)this.decider.state[n] - this.op(this.decider.state[this.sourceIndex]));
                break;
            }
            case MULTIPLY: {
                int n = this.targetIndex;
                this.decider.state[n] = (int)((float)this.decider.state[n] * (0.5f + (float)this.decider.state[this.sourceIndex] / (float)this.decider.numStates));
            }
        }
        this.decider.state[this.targetIndex] = this.constrain(this.decider.state[this.targetIndex]);
        int n = this.targetIndex;
        this.decider.stateChangeCount[n] = this.decider.stateChangeCount[n] + 1;
        int n2 = this.sourceIndex;
        this.decider.stateInfluenceCount[n2] = this.decider.stateInfluenceCount[n2] + 1;
    }

    private int constrain(int x) {
        while (x < 0) {
            x += this.decider.numStates;
        }
        return x % this.decider.numStates;
    }

    public static Process newRandom(Decider d) {
        Process p = new Process(d);
        p.op = BinaryOp.values()[d.rng.nextInt(3)];
        p.sourceIndex = d.nextRandomSourceIndex();
        p.targetIndex = d.nextRandomTargetIndex();
        return p;
    }

    @Override
    protected void resetCounts() {
        super.resetCounts();
    }

    @Override
    protected Operation copyMutate(Decider newDecider) {
        Process copy = new Process(newDecider);
        copy.op = this.op;
        copy.sourceIndex = this.sourceIndex;
        copy.targetIndex = this.targetIndex;
        if (this.decider.prob(0.05f)) {
            copy.op = BinaryOp.values()[this.decider.rng.nextInt(3)];
        }
        if (this.decider.prob(0.05f)) {
            copy.sourceIndex = this.decider.nextRandomSourceIndex();
        }
        if (this.decider.prob(0.05f)) {
            copy.targetIndex = this.decider.nextRandomTargetIndex();
        }
        return copy;
    }

    @Override
    protected Operation copy(Decider newDecider) {
        Process copy = new Process(newDecider);
        copy.op = this.op;
        copy.sourceIndex = this.sourceIndex;
        copy.targetIndex = this.targetIndex;
        return copy;
    }

    static enum BinaryOp implements Serializable
    {
        ADD,
        SUBTRACT,
        MULTIPLY;

    }
}

