/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.core.Decider;
import decider.drawing.DeciderDrawer;
import decider.drawing.DeciderManagerPanel;
import decider.drawing.DeciderManagerPanelListener;
import decider.drawing.SceneDrawer;
import decider.drawing.SplitSceneDrawerCompact;
import decider.drawing.TimerDrawer;
import decider.drawing.XSceneDrawer;
import decider.play.DeciderAgent;
import decider.play.Scene;
import decider.play.SplitScene;
import decider.play.XScene;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeciderAgentDrawer
extends JPanel {
    private static final long serialVersionUID = 1L;
    DeciderAgent da;
    SceneDrawer sd;
    DeciderDrawer dd;
    JPanel readOutPanel;

    public DeciderAgentDrawer(DeciderAgent dda) {
        this.da = dda;
        this.setLayout(new BoxLayout(this, 1));
        this.readOutPanel = new JPanel();
        this.readOutPanel.setLayout(new BoxLayout(this.readOutPanel, 0));
        this.readOutPanel.setAlignmentX(0.0f);
        this.add(this.readOutPanel);
        this.buildReadoutPanel();
        this.da.addSceneChangeListener(new DeciderAgent.SceneChangeListener(){

            @Override
            public void sceneChanged(Scene newScene) {
                DeciderAgentDrawer.this.buildReadoutPanel();
            }
        });
        JPanel timerPanel = new JPanel();
        timerPanel.setLayout(new BoxLayout(timerPanel, 0));
        TimerDrawer td = new TimerDrawer(this.da.getTimer());
        timerPanel.setAlignmentX(0.0f);
        timerPanel.add(td);
        timerPanel.add(Box.createHorizontalStrut(10));
        timerPanel.add(new JLabel("< < future scenes < < "));
        this.add(Box.createVerticalStrut(10));
        this.add(timerPanel);
        DeciderManagerPanel dmp = new DeciderManagerPanel(new DeciderManagerPanelListener(){

            @Override
            public void setDecider(Decider d) {
                DeciderAgentDrawer.this.da.getCurrentScene().setDecider(d);
                DeciderAgentDrawer.this.dd.setDecider(d);
            }

            @Override
            public Decider getDecider() {
                return DeciderAgentDrawer.this.da.getCurrentScene().getDecider();
            }
        });
        dmp.setAlignmentX(0.0f);
        this.add(dmp);
        JPanel sceneButtonPanel = new JPanel();
        sceneButtonPanel.setLayout(new BoxLayout(sceneButtonPanel, 0));
        sceneButtonPanel.add(new JLabel("Scene Controls"));
        sceneButtonPanel.add(Box.createHorizontalStrut(10));
        JButton readB = new JButton("Read Scene");
        readB.setPreferredSize(new Dimension(100, 20));
        readB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ch = new JFileChooser(new File(String.valueOf(System.getProperty("user.dir")) + "/scenes"));
                int returnVal = ch.showOpenDialog(DeciderAgentDrawer.this.getTopLevelAncestor());
                if (returnVal == 0) {
                    try {
                        File f = ch.getSelectedFile();
                        FileInputStream fis = new FileInputStream(f);
                        ObjectInputStream ois = new ObjectInputStream(fis);
                        Scene newS = (Scene)ois.readObject();
                        newS.setName(f.getName());
                        DeciderAgentDrawer.this.setScene(newS);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        sceneButtonPanel.add(readB);
        sceneButtonPanel.add(Box.createHorizontalStrut(10));
        JButton saveB = new JButton("Save Scene");
        saveB.setPreferredSize(new Dimension(100, 20));
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ch = new JFileChooser(new File(System.getProperty("user.dir")));
                int returnVal = ch.showSaveDialog(DeciderAgentDrawer.this.getTopLevelAncestor());
                if (returnVal == 0) {
                    try {
                        File f = ch.getSelectedFile();
                        FileOutputStream fos = new FileOutputStream(f);
                        ObjectOutputStream oos = new ObjectOutputStream(fos);
                        oos.writeObject(DeciderAgentDrawer.this.da.getCurrentScene());
                        oos.close();
                        fos.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        sceneButtonPanel.add(saveB);
        sceneButtonPanel.add(Box.createHorizontalStrut(10));
        JButton addScene = new JButton("Add Scene to End");
        addScene.setPreferredSize(new Dimension(200, 20));
        addScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ch = new JFileChooser();
                int returnVal = ch.showOpenDialog(DeciderAgentDrawer.this.getTopLevelAncestor());
                if (returnVal == 0) {
                    try {
                        File f = ch.getSelectedFile();
                        FileInputStream fis = new FileInputStream(f);
                        ObjectInputStream ois = new ObjectInputStream(fis);
                        Scene newS = (Scene)ois.readObject();
                        newS.setName(f.getName());
                        DeciderAgentDrawer.this.addScene(newS);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        sceneButtonPanel.add(addScene);
        sceneButtonPanel.add(Box.createHorizontalStrut(10));
        sceneButtonPanel.setAlignmentX(0.0f);
        this.add(sceneButtonPanel);
    }

    private void buildReadoutPanel() {
        this.readOutPanel.removeAll();
        this.dd = new DeciderDrawer(this.da.getCurrentScene().getDecider());
        Scene currentScene = this.da.getCurrentScene();
        this.sd = this.correctDrawerForScene(currentScene, false);
        this.readOutPanel.add(this.dd);
        this.readOutPanel.add(this.sd);
        this.readOutPanel.add(Box.createHorizontalStrut(10));
        for (Scene scene : this.da.getFutureScenes()) {
            this.readOutPanel.add(this.correctDrawerForScene(scene, true));
        }
        this.readOutPanel.revalidate();
        this.readOutPanel.repaint();
        if (this.readOutPanel.getTopLevelAncestor() != null) {
            JFrame jFrame = (JFrame)this.readOutPanel.getTopLevelAncestor();
            jFrame.pack();
            jFrame.repaint();
        }
    }

    private SceneDrawer correctDrawerForScene(Scene s, boolean narrow) {
        if (s instanceof SplitScene) {
            return new SplitSceneDrawerCompact((SplitScene)s, narrow);
        }
        if (s instanceof XScene) {
            return new XSceneDrawer((XScene)s, narrow);
        }
        return null;
    }

    public void setScene(Scene s) {
        this.da.setCurrentScene(s);
        this.sd.setScene(s);
        this.dd.setDecider(s.getDecider());
    }

    public void addScene(Scene s) {
        this.da.addSceneToQueue(s);
        this.buildReadoutPanel();
    }
}

