/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.core.Decider;
import decider.drawing.DeciderManagerPanelListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeciderManagerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DeciderManagerPanelListener listener;

    public DeciderManagerPanel(DeciderManagerPanelListener llistener) {
        this.listener = llistener;
        DeciderManagerPanel buttonPanel = this;
        buttonPanel.add(new JLabel("Decider controls"));
        buttonPanel.add(Box.createHorizontalStrut(10));
        JButton newB = new JButton("New Random");
        newB.setPreferredSize(new Dimension(100, 20));
        newB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Decider newD = Decider.newRandomTree(6, 30, DeciderManagerPanel.this.listener.getDecider().getRng(), 0.05f);
                DeciderManagerPanel.this.listener.setDecider(newD);
            }
        });
        buttonPanel.add(newB);
        JButton resetB = new JButton("Reset");
        resetB.setPreferredSize(new Dimension(100, 20));
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeciderManagerPanel.this.listener.getDecider().centerState();
            }
        });
        buttonPanel.add(resetB);
        JButton mutateB = new JButton("Mutate");
        mutateB.setPreferredSize(new Dimension(100, 20));
        mutateB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Decider newD = DeciderManagerPanel.this.listener.getDecider().copyMutate();
                DeciderManagerPanel.this.listener.setDecider(newD);
            }
        });
        buttonPanel.add(mutateB);
        JButton readB = new JButton("Read");
        readB.setPreferredSize(new Dimension(100, 20));
        readB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ch = new JFileChooser(new File(String.valueOf(System.getProperty("user.dir")) + "/deciders"));
                int returnVal = ch.showOpenDialog(DeciderManagerPanel.this.getTopLevelAncestor());
                if (returnVal == 0) {
                    try {
                        File f = ch.getSelectedFile();
                        FileInputStream fis = new FileInputStream(f);
                        ObjectInputStream ois = new ObjectInputStream(fis);
                        Decider newD = (Decider)ois.readObject();
                        newD.setConsolidate(false);
                        newD.centerState();
                        DeciderManagerPanel.this.listener.setDecider(newD);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        buttonPanel.add(readB);
        JButton saveB = new JButton("Save");
        saveB.setPreferredSize(new Dimension(100, 20));
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ch = new JFileChooser(new File(System.getProperty("user.dir")));
                int returnVal = ch.showSaveDialog(DeciderManagerPanel.this.getTopLevelAncestor());
                if (returnVal == 0) {
                    try {
                        File f = ch.getSelectedFile();
                        FileOutputStream fos = new FileOutputStream(f);
                        ObjectOutputStream oos = new ObjectOutputStream(fos);
                        oos.writeObject(DeciderManagerPanel.this.listener.getDecider());
                        oos.close();
                        fos.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        buttonPanel.add(saveB);
    }
}

