/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.core.Decider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class StateDrawer
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Decider d;

    public StateDrawer(Decider dc) {
        this.d = dc;
        Dimension dim = new Dimension(300, 50);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
    }

    @Override
    public void paintComponent(Graphics g) {
        int stateHeight;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int step = this.getWidth() / this.d.getNumElements();
        g.setColor(Color.lightGray);
        int x = 0;
        int i = 0;
        while (i < this.d.getNumInputs()) {
            stateHeight = (int)(this.d.getInputFract(i) * (float)this.getHeight());
            g.fillRect(x++ * step, this.getHeight() - stateHeight, step, stateHeight);
            ++i;
        }
        i = 0;
        while (i < this.d.getNumHiddenElements()) {
            stateHeight = (int)(this.d.getStateFract(i) * (float)this.getHeight());
            g.fillRect(x++ * step, this.getHeight() - stateHeight, step, stateHeight);
            ++i;
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public static StateDrawer draw(final Decider d) {
        final StateDrawer dr = new StateDrawer(d);
        JFrame f = new JFrame();
        f.getContentPane().add(dr);
        f.setSize(500, 200);
        f.setVisible(true);
        f.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    d.setConsolidate(!d.consolidateModeOn());
                }
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    dr.repaint();
                    try {
                        2.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
        return dr;
    }

    public void setDecider(Decider newD) {
        this.d = newD;
        this.repaint();
    }
}

