/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.play.Timer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class TimerDrawer
extends JComponent {
    private static final long serialVersionUID = 1L;
    Timer t;
    float adjustedTime;

    public TimerDrawer(Timer t) {
        this.setTimer(t);
        Dimension d = new Dimension(400, 20);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.adjustedTime = -1.0f;
        t.setActive(false);
    }

    public void setTimer(Timer t2) {
        this.t = t2;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getX() > 5 && e.getX() < TimerDrawer.this.getHeight() - 5 && e.getY() > 5 && e.getY() < TimerDrawer.this.getHeight() - 5) {
                    TimerDrawer.this.t.setActive(!TimerDrawer.this.t.isActive());
                    TimerDrawer.this.repaint();
                } else {
                    TimerDrawer.this.setAdjustedTime((float)e.getX() / (float)TimerDrawer.this.getWidth());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TimerDrawer.this.sendTime();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                TimerDrawer.this.setAdjustedTime((float)e.getX() / (float)TimerDrawer.this.getWidth());
            }
        });
    }

    private void setAdjustedTime(float time) {
        this.adjustedTime = Math.min(time, 1.0f);
    }

    private void sendTime() {
        if (this.adjustedTime != -1.0f) {
            this.t.setTime(this.adjustedTime);
        }
        this.adjustedTime = -1.0f;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.t.isActive()) {
            g.setColor(Color.lightGray);
            g.fillRect(5, 5, this.getHeight() - 10, this.getHeight() - 10);
        }
        g.setColor(Color.black);
        g.drawRect(5, 5, this.getHeight() - 10, this.getHeight() - 10);
        int pos = (int)(this.t.getTime() * (float)this.getWidth());
        g.drawLine(pos, 0, pos, this.getHeight());
        if (this.adjustedTime >= 0.0f) {
            g.setColor(Color.red);
            pos = (int)(this.adjustedTime * (float)this.getWidth());
            g.drawLine(pos, 0, pos, this.getHeight());
        }
    }
}

