/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.drawing.SceneDrawer;
import decider.play.DeciderSoundEvent;
import decider.play.Scene;
import decider.play.SoundEventUtil;
import decider.play.XScene;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XSceneDrawer
extends SceneDrawer {
    private XScene xs;
    private int nameTextHeight = 100;
    boolean turnon;

    public XSceneDrawer(XScene xsx) {
        this(xsx, false);
    }

    public XSceneDrawer(XScene xsx, boolean compact) {
        this.xs = xsx;
        this.turnon = true;
        this.setLayout(new BoxLayout(this, 1));
        if (compact) {
            JComponent xsd = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            };
            Dimension d = new Dimension(50, 450);
            xsd.setMinimumSize(d);
            xsd.setPreferredSize(d);
            xsd.setMaximumSize(d);
            this.add(xsd);
        } else {
            JComponent soundEventNames = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor(Color.white);
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2d.setColor(Color.black);
                    g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    g2d.setFont(new Font("Courier", 0, 10));
                    int boxWidth = this.getWidth() / SoundEventUtil.eventClasses.length;
                    int i = 1;
                    Class<? extends DeciderSoundEvent>[] classArray = SoundEventUtil.eventClasses;
                    int n = SoundEventUtil.eventClasses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<? extends DeciderSoundEvent> cclass = classArray[n2];
                        g2d.rotate(-1.5707963267948966);
                        g2d.drawString(cclass.getSimpleName(), -XSceneDrawer.this.nameTextHeight + 5, i * boxWidth - 5);
                        g2d.drawLine(-XSceneDrawer.this.nameTextHeight, i * boxWidth, 0, i * boxWidth);
                        g2d.rotate(1.5707963267948966);
                        ++i;
                        ++n2;
                    }
                }
            };
            this.add(soundEventNames);
            final JComponent xsd = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    boolean[][] sa = XSceneDrawer.this.xs.getStateArray();
                    int width = this.getWidth() / sa.length;
                    int height = this.getHeight() / sa[0].length;
                    int i = 0;
                    while (i < sa.length) {
                        int j = 0;
                        while (j < sa[i].length) {
                            if (sa[i][j]) {
                                g.fillRect(i * width, j * height, width, height);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    String name = XSceneDrawer.this.xs.getName();
                    if (name != null) {
                        g.setColor(Color.lightGray);
                        g.drawString(name, 10, 20);
                    }
                }
            };
            xsd.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    boolean[][] sa = XSceneDrawer.this.xs.getStateArray();
                    int x = (int)((float)e.getX() / (float)xsd.getWidth() * (float)sa.length);
                    int y = (int)((float)e.getY() / (float)xsd.getHeight() * (float)sa[0].length);
                    if (x < sa.length && x >= 0 && y < sa[0].length && y >= 0) {
                        sa[x][y] = XSceneDrawer.this.turnon = !sa[x][y];
                    }
                }
            });
            xsd.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    boolean[][] sa = XSceneDrawer.this.xs.getStateArray();
                    int x = (int)((float)e.getX() / (float)xsd.getWidth() * (float)sa.length);
                    int y = (int)((float)e.getY() / (float)xsd.getHeight() * (float)sa[0].length);
                    if (x < sa.length && x >= 0 && y < sa[0].length && y >= 0) {
                        sa[x][y] = XSceneDrawer.this.turnon;
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            this.add(xsd);
            final JSlider richter = new JSlider(0, 100);
            richter.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    XSceneDrawer.this.xs.setRichterScale((float)richter.getValue() / 100.0f);
                }
            });
            this.add(richter);
            Dimension d = new Dimension(350, 350);
            xsd.setMinimumSize(d);
            xsd.setPreferredSize(d);
            xsd.setMaximumSize(d);
            d = new Dimension(350, 100);
            soundEventNames.setMinimumSize(d);
            soundEventNames.setPreferredSize(d);
            soundEventNames.setMaximumSize(d);
        }
    }

    @Override
    public void setScene(Scene s) {
        this.xs = (XScene)s;
    }
}

