/*
 * Decompiled with CFR 0.152.
 */
package decider.evolve;

import decider.core.Decider;
import decider.evolve.DeciderFitnessFunctionVersion4;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Random;

public class GA {
    public static void main(String[] args) {
        String dir = "dudes";
        File dataFolder = new File("/Users/ollie/Data/ACALCI/evolved deciders/" + dir);
        dataFolder.mkdir();
        dir = dataFolder.getAbsolutePath();
        int popSize = 100;
        int iterations = 1000000;
        DeciderFitnessFunctionVersion4 ff = new DeciderFitnessFunctionVersion4();
        Random rng = new Random();
        Decider[] pop = new Decider[popSize];
        float[] fitness = new float[popSize];
        int fittest = 0;
        int i = 0;
        while (i < popSize) {
            pop[i] = Decider.newRandomTree(6, 30, rng, 0.05f);
            fitness[i] = ff.evaluate(pop[i]);
            if (fitness[i] > fitness[fittest]) {
                fittest = i;
            }
            ++i;
        }
        int time = 0;
        while (time < iterations) {
            int a;
            int b = a = rng.nextInt(popSize);
            while (b == a) {
                b = rng.nextInt(popSize);
            }
            int winner = fitness[a] > fitness[b] ? a : b;
            int loser = winner == a ? b : a;
            pop[loser] = pop[winner].copyMutate();
            fitness[loser] = ff.evaluate(pop[loser]);
            if (fitness[loser] > fitness[fittest]) {
                fittest = loser;
            }
            if (time % 100 == 0) {
                System.out.println("----------------------");
                System.out.println("fittest : fitness=" + fitness[fittest]);
                GA.write(dir, pop[fittest], time);
            }
            ++time;
        }
    }

    private static void write(String dir, Decider decider, int gen) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(String.valueOf(dir) + "/gen" + gen));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(decider);
            oos.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

