/*
 * Decompiled with CFR 0.152.
 */
package decider.play;

import decider.core.Decider;
import decider.play.Scene;
import decider.play.Timer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.beadsproject.beads.analysis.Analyzer;
import net.beadsproject.beads.analysis.FeatureFrame;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Pitch;

public class DeciderAgent {
    private ArrayList<SceneChangeListener> sceneChangeListeners;
    private Scene currentScene;
    private Queue<Scene> futureScenes;
    private UGen output;
    private Analyzer listener;
    private Timer timer;
    private float[] inputData;

    public DeciderAgent(Scene s, UGen o, Analyzer a) {
        this.output = o;
        this.futureScenes = new LinkedList<Scene>();
        this.sceneChangeListeners = new ArrayList();
        this.timer = new Timer();
        this.setCurrentScene(s);
        this.listener = a;
        this.inputData = new float[8];
        this.listener.addSegmentListener(new SegmentListener(){

            @Override
            public void newSegment(TimeStamp start, TimeStamp end) {
                FeatureFrame ff = DeciderAgent.this.listener.getLastLowLevelFrame();
                if (DeciderAgent.this.currentScene == null) {
                    System.out.println("DeciderAgent: scene == null, waiting...");
                    return;
                }
                DeciderAgent.this.setDeciderStatesFromFeatureFrame(ff);
                DeciderAgent.this.currentScene.process(DeciderAgent.this.output);
                DeciderAgent.this.timer.tick((DeciderAgent.this.currentScene.getDecider().getStateFract(0) + DeciderAgent.this.currentScene.getDecider().getStateFract(1)) / 10000.0f);
                if (DeciderAgent.this.timer.timeElapsed()) {
                    DeciderAgent.this.flipToNextScene();
                }
            }
        });
    }

    private void setDeciderStatesFromFeatureFrame(FeatureFrame ff) {
        DeciderAgent.getInputDataFromFeatures(ff, this.inputData);
        int i = 0;
        while (i < 6) {
            this.currentScene.setInputFract(i, this.inputData[i]);
            ++i;
        }
    }

    public static void getInputDataFromFeatures(FeatureFrame ff, float[] inputData) {
        if (ff != null) {
            Float f = (Float)ff.get(SpectralCentroid.class.getSimpleName());
            if (f != null) {
                inputData[2] = Pitch.ftom(f.floatValue()) / 127.0f;
            }
            if ((f = (Float)ff.get(Frequency.class.getSimpleName())) != null) {
                inputData[3] = Pitch.ftom(f.floatValue()) / 127.0f;
                if (Float.isNaN(inputData[1])) {
                    inputData[1] = 1.0f;
                }
            }
            if ((f = (Float)ff.get(Power.class.getSimpleName())) != null) {
                inputData[4] = f.floatValue() * 10.0f;
            }
            if ((f = Float.valueOf(((float[])ff.get(MFCC.class.getSimpleName()))[0])) != null) {
                inputData[5] = f.floatValue() / 4.0f;
            }
            if ((f = Float.valueOf(((float[])ff.get(MFCC.class.getSimpleName()))[7])) != null) {
                inputData[6] = (f.floatValue() + 0.5f) / 4.0f;
            }
            if ((f = Float.valueOf(((float[])ff.get(MFCC.class.getSimpleName()))[14])) != null) {
                inputData[7] = (f.floatValue() + 0.5f) / 4.0f;
            }
        }
    }

    public void flipToNextScene() {
        if (this.futureScenes.peek() != null) {
            if (this.currentScene != null) {
                this.currentScene.dispose();
            }
            this.currentScene = this.futureScenes.poll();
            for (SceneChangeListener scl : this.sceneChangeListeners) {
                scl.sceneChanged(this.currentScene);
            }
            this.timer.reset();
        }
    }

    public void addSceneChangeListener(SceneChangeListener scl) {
        this.sceneChangeListeners.add(scl);
    }

    public void removeSceneChangeListener(SceneChangeListener scl) {
        this.sceneChangeListeners.remove(scl);
    }

    public Scene getCurrentScene() {
        return this.currentScene;
    }

    public void setCurrentScene(Scene scene) {
        if (this.currentScene != null) {
            this.currentScene.dispose();
        }
        this.currentScene = scene;
        this.timer.reset();
    }

    public void addSceneToQueue(Scene scene) {
        this.futureScenes.add(scene);
    }

    public Decider getDecider() {
        return this.currentScene.getDecider();
    }

    public Queue<? extends Scene> getFutureScenes() {
        return this.futureScenes;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void timeSignal(float tickCount, float beatCount) {
        this.inputData[0] = tickCount;
        this.inputData[1] = beatCount;
    }

    public static interface SceneChangeListener {
        public void sceneChanged(Scene var1);
    }
}

