/*
 * Decompiled with CFR 0.152.
 */
package decider.play;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import decider.play.Scene;
import decider.play.SoundEventUtil;
import java.util.Hashtable;
import java.util.Map;
import net.beadsproject.beads.core.UGen;

public class XScene
implements Scene {
    private static final long serialVersionUID = 1L;
    public static final int DIVISIONS = 20;
    private Decider decider;
    private String name;
    private float richterScale;
    private boolean[][] state = new boolean[SoundEventUtil.eventClasses.length][20];
    private transient Map<Class<? extends DeciderSoundEvent>, DeciderSoundEvent> events;

    @Override
    public void dispose() {
        if (this.events != null) {
            for (DeciderSoundEvent event : this.events.values()) {
                event.destroy();
            }
        }
    }

    @Override
    public void process(UGen output) {
        if (this.decider != null) {
            this.decider.process();
            float fract = (float)this.decider.getCurrentLeaf() / (float)this.decider.getNumLeaves();
            int index = (int)(fract * 20.0f);
            int i = 0;
            while (i < this.state.length) {
                if (this.state[i][index]) {
                    DeciderSoundEvent myEvent;
                    Class<? extends DeciderSoundEvent> myEventClass = SoundEventUtil.eventClasses[i];
                    if (this.events == null) {
                        this.events = new Hashtable<Class<? extends DeciderSoundEvent>, DeciderSoundEvent>();
                    }
                    if ((myEvent = this.events.get(myEventClass)) == null) {
                        myEvent = SoundEventUtil.eventFromClass(myEventClass);
                        this.events.put(myEventClass, myEvent);
                    }
                    myEvent.play(output, this.decider.getCurrentLeaf(), this.decider);
                }
                ++i;
            }
        }
    }

    public boolean[][] getStateArray() {
        return this.state;
    }

    @Override
    public void setInputFract(int i, float f) {
        this.decider.setInputFract(i, f);
    }

    @Override
    public void setDecider(Decider d) {
        this.decider = d;
    }

    @Override
    public Decider getDecider() {
        return this.decider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public float getRichterScale() {
        return this.richterScale;
    }

    public void setRichterScale(float richterScale) {
        this.richterScale = richterScale;
    }
}

