/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_1;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.analysis.FeatureManager;
import net.beadsproject.beads.analysis.FeatureSet;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.Mult;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;

public class BassClarinetSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    private int lastIndex;
    private Envelope currentSoundEnv;
    private Gain currentSound;
    private Gain master;
    private PolyLimit pl;
    private Glide gainGlide = null;
    private Glide rateGlide = null;
    private Glide bqFreqGlide = null;
    private BiquadFilter bq;
    private int timeSince = 0;
    private int changeThresh = 4;
    private boolean verbose = false;

    static {
        SampleManager.group("bc", "audio/highattack");
    }

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        AudioContext ac = output.getContext();
        if (this.gainGlide == null) {
            this.gainGlide = new Glide(ac, 0.0f, 500.0f);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            this.master = new Gain(ac, 2, new Mult(ac, this.gainGlide, (UGen)staticGain));
            output.addInput(this.master);
            this.rateGlide = new Glide(ac, 0.0f, 500.0f);
            this.bq = new BiquadFilter(ac, 2);
            this.bqFreqGlide = new Glide(ac, 0.0f, 500.0f);
            this.bq.setFrequency(this.bqFreqGlide);
            this.bq.setQ(4.0f);
            this.pl = new PolyLimit(ac, 2, 6);
            this.bq.addInput(this.pl);
            this.master.addInput(this.bq);
        }
        this.gainGlide.setValue(DSEControl.getGain(decider));
        this.rateGlide.setValue((float)Math.pow(DSEControl.getBaseFreq(decider), 0.9f) + 0.2f);
        this.bqFreqGlide.setValue((float)Math.pow(DSEControl.getFilterFreq(decider), 1.2f) * 20000.0f + 1000.0f);
        ++this.timeSince;
        if (thisIndex != this.lastIndex && this.timeSince > this.changeThresh) {
            SamplePlayer sp;
            this.timeSince = 0;
            this.lastIndex = thisIndex;
            if (this.currentSoundEnv != null) {
                this.currentSoundEnv.addSegment(0.0f, 200.0f, new KillTrigger(this.currentSound));
            }
            if (this.verbose) {
                System.out.println("sound " + thisIndex);
            }
            Sample s = SampleManager.fromGroup("bc", thisIndex);
            if (DSEControl.getProbA(decider, 0.8f)) {
                sp = new SamplePlayer(ac, s);
            } else {
                GranularSamplePlayer gsp = new GranularSamplePlayer(ac, s);
                gsp.getGrainSizeUGen().setValue(100.0f);
                gsp.getGrainIntervalUGen().setValue(20.0f + DSEControl.getParameterA(decider) * 20.0f);
                gsp.setRate(this.rateGlide);
                sp = gsp;
            }
            sp.getPitchUGen().setValue(2.0f);
            FeatureSet features = FeatureManager.featuresForSampleIfLoaded(s);
            double startTime = 0.0;
            if (features != null && features.contains("StartTime")) {
                startTime = (Double)features.getGlobal("StartTime");
            }
            sp.setPosition(startTime);
            if (DSEControl.getProbB(decider, 0.2f)) {
                sp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
                sp.getLoopStartUGen().setValue((float)startTime + 200.0f);
                float loopEnd = (float)startTime + 300.0f + 1200.0f * DSEControl.getParameterB(decider);
                if ((double)loopEnd > sp.getSample().getLength()) {
                    loopEnd = (float)sp.getSample().getLength();
                    sp.getLoopStartUGen().setValue((float)startTime);
                }
                sp.getLoopEndUGen().setValue(loopEnd);
            }
            Envelope e = new Envelope(ac, 1.0f * (float)Math.pow(DSEControl.getParameterC(decider), 1.0));
            Gain g = new Gain(ac, 2, e);
            g.addInput(sp);
            this.pl.addInput(g);
            this.currentSoundEnv = e;
            this.currentSound = g;
            return this.master;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.master != null) {
            this.master.kill();
        }
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/jazzdrum_decider2"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

