/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_1;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.SamplePlayer;

public class BirdSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    private Gain master;
    private GranularSamplePlayer gsp;
    private Envelope gainEnv;
    private Glide rate;
    private Glide pitch;
    private Glide rand;
    private Glide panRand;
    private Glide bandFreq;
    private Gain gain;
    private int last = -1;

    static {
        SampleManager.sample("bird", "audio/Birds/17185_reinsamba_Nightingale_song_3.wav");
    }

    @Override
    public void init() {
    }

    private void setup(UGen output) {
        AudioContext ac = output.getContext();
        this.gsp = new GranularSamplePlayer(ac, SampleManager.sample("bird"));
        this.gsp.setLoopType(SamplePlayer.LoopType.LOOP_BACKWARDS);
        this.rate = new Glide(ac, 0.0f, 200.0f);
        this.gsp.setRate(this.rate);
        this.pitch = new Glide(ac, 1.0f, 200.0f);
        this.gsp.setPitch(this.pitch);
        this.rand = new Glide(ac, 0.0f);
        this.gsp.setRandomness(this.rand);
        this.panRand = new Glide(ac, 0.0f);
        this.gsp.setRandomPan(this.panRand);
        this.bandFreq = new Glide(ac, 0.0f, 200.0f);
        BiquadFilter bf = new BiquadFilter(ac, 2);
        bf.setFrequency(this.bandFreq);
        bf.setQ(0.8f);
        this.gainEnv = new Envelope(ac, 0.0f);
        this.gain = new Gain(ac, 2, this.gainEnv);
        bf.addInput(this.gsp);
        this.gain.addInput(bf);
        if (staticGain == null) {
            staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
        }
        this.master = new Gain(ac, 2, staticGain);
        output.addInput(this.master);
        this.master.addInput(this.gain);
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        boolean init = false;
        if (this.gsp == null) {
            this.setup(output);
            init = true;
        }
        float currentGain = this.gainEnv.getValue();
        currentGain = Math.min(1.0f, currentGain + 0.02f);
        this.gainEnv.setValue(currentGain);
        this.gainEnv.addSegment(0.0f, 10000.0f);
        if (thisIndex != this.last) {
            float targetRate = 0.0f;
            if (thisIndex > 10) {
                targetRate = (float)Math.pow((float)(thisIndex % 100) / 100.0f, 2.0) * 4.0f;
            }
            this.rate.setValue(targetRate);
            float targetPitch = (float)(thisIndex % 100) / 100.0f + 0.5f;
            this.pitch.setValue(targetPitch);
            this.rand.setValue((float)Math.pow(DSEControl.getParameterA(decider), 1.0) * 0.5f);
            this.panRand.setValue(DSEControl.getParameterB(decider));
            if (decider.prob(0.2f)) {
                double newPos = this.gsp.getSample().getLength() * (double)(thisIndex % 32) / 32.0;
                this.gsp.setPosition(newPos);
            }
        }
        this.last = thisIndex;
        float interval = decider.getStateFract(2) * 60.0f + 20.0f;
        float size = interval * (DSEControl.getParameterC(decider) * 3.0f + 1.5f);
        this.gsp.getGrainIntervalUGen().setValue(interval);
        this.gsp.getGrainSizeUGen().setValue(size);
        this.bandFreq.setValue(DSEControl.getFilterFreq(decider) * 16000.0f + 1000.0f);
        return init ? this.gain : null;
    }

    @Override
    public void destroy() {
        if (this.master != null) {
            this.master.kill();
        }
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/bird_decider"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

