/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_1;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.Mult;
import net.beadsproject.beads.ugens.OnePoleFilter;
import net.beadsproject.beads.ugens.WavePlayer;

public class SynthSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    private int next;
    private int count = 0;
    private int last = -1;
    private Glide gainVal;
    private Glide filtFreq;
    private Gain gain;
    private WavePlayer ringMod;
    private OnePoleFilter opf;
    private Glide ringModAmount;
    private int[] scale1;
    private Gain lastGain;
    private Envelope lastEnvelope;

    public SynthSoundEvent() {
        int[] nArray = new int[5];
        nArray[1] = 3;
        nArray[2] = 5;
        nArray[3] = 7;
        nArray[4] = 10;
        this.scale1 = nArray;
    }

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen o, int i, Decider d) {
        AudioContext ac = o.getContext();
        this.next = 0;
        Gain sound = null;
        if (this.gain == null) {
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            this.gainVal = new Glide(ac, 0.0f, 500.0f);
            this.gain = new Gain(ac, 2, new Mult(ac, this.gainVal, (UGen)staticGain));
            this.filtFreq = new Glide(ac, 0.0f, 200.0f);
            this.opf = new OnePoleFilter(ac, this.filtFreq);
            this.opf.addInput(this.gain);
            o.addInput(this.opf);
            sound = this.gain;
            this.ringMod = new WavePlayer(ac, 1000.0f, Buffer.SAW);
            this.ringModAmount = new Glide(ac, 0.5f, 200.0f);
        }
        if (this.count % 4 == 0) {
            this.gainVal.setValue(DSEControl.getGain(d) * 0.6f + 0.4f);
            this.filtFreq.setValue(DSEControl.getFilterFreq(d) * 10000.0f + 500.0f);
            this.ringModAmount.setValue((float)Math.pow(DSEControl.getParameterA(d), 1.1f));
        }
        if (this.count % 64 == 0 && this.last != i) {
            float frq = this.freq(i, this.scale1);
            WavePlayer wp = new WavePlayer(ac, frq, Buffer.SQUARE);
            Envelope e = new Envelope(ac, 0.1f);
            Gain g = new Gain(ac, 2, e);
            e.addSegment(0.02f, 1000.0f);
            e.addSegment(0.0f, 2000.0f, 2.0f, new KillTrigger(g));
            Function m = new Function(new UGen[]{wp, this.ringMod, this.ringModAmount}){

                @Override
                public float calculate() {
                    float result = this.x[0] * ((this.x[1] * 0.5f - 0.5f) * this.x[2] + 1.0f);
                    return result;
                }
            };
            g.addInput(m);
            this.gain.addInput(g);
        }
        ++this.count;
        this.last = i;
        return sound;
    }

    private float freq(int index, int[] scale) {
        int note = index % 72 + 24;
        note = Pitch.forceToScale(note, scale);
        return Pitch.mtof(note);
    }

    @Override
    public void destroy() {
        if (this.opf != null) {
            this.opf.kill();
        }
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/string_res_decider"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

