/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.LPRezFilter;
import net.beadsproject.beads.ugens.OscillatorBank;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;

public class OscDelaySoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    int numOscs;
    OscillatorBank osc;
    float[] freqs;
    float[] amps;
    LPRezFilter lpFilt;
    Envelope gainEnv;
    Gain gain;
    int lastIndex;
    int count;
    TapIn in;
    TapOut out1;
    TapOut out2;

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        float val;
        AudioContext ac = output.getContext();
        if (this.osc == null) {
            this.numOscs = 10;
            this.osc = new OscillatorBank(ac, Buffer.SINE, this.numOscs);
            this.freqs = new float[this.numOscs];
            this.amps = new float[this.numOscs];
            this.lpFilt = new LPRezFilter(ac, 2);
            this.lpFilt.addInput(this.osc);
            this.lpFilt.setFrequency(new Glide(ac, 100.0f));
            this.lpFilt.setRes(new Glide(ac, 100.0f));
            this.in = new TapIn(ac, 5000.0f);
            this.out1 = new TapOut(ac, this.in, new Glide(ac, 50.0f, 5.0f));
            this.out2 = new TapOut(ac, this.in, new Glide(ac, 50.0f, 5.0f));
            this.in.addInput(this.lpFilt);
            this.gainEnv = new Envelope(ac, 0.0f);
            this.gain = new Gain(ac, 2, this.gainEnv);
            this.gain.addInput(this.osc);
            output.addInput(this.gain);
        }
        int next = 0;
        float detune = decider.getStateFract(next++);
        if (this.count % (int)((val = decider.getStateFract(next++)) * 200.0f + 1.0f) == 0) {
            if (thisIndex != this.lastIndex) {
                int i = 0;
                while (i < this.numOscs) {
                    float freq;
                    val = decider.getStateFract(next++);
                    int note = (int)((1.0f - val * val) * 100.0f + 32.0f);
                    note = Pitch.forceToScale(note, Pitch.major);
                    this.freqs[i] = freq = Pitch.mtof(note);
                    int n = i;
                    this.freqs[n] = this.freqs[n] + (detune * 10.0f - 5.0f);
                    val = decider.getStateFract(next++);
                    this.amps[i] = val * Math.min(1.0f, 1.0f - freq / 10000.0f);
                    ++i;
                }
                this.osc.setFrequencies(this.freqs);
                this.osc.setGains(this.amps);
                float newGain = (1.0f - val * val) * 0.1f;
                this.gainEnv.clear();
                this.gainEnv.addSegment(newGain, 100.0f);
                this.gainEnv.addSegment(newGain, 100.0f);
                this.gainEnv.addSegment(0.0f, 5000.0f);
            }
            this.lastIndex = thisIndex;
        }
        ++this.count;
        val = decider.getStateFract(next++);
        val = decider.getStateFract(next++);
        this.lpFilt.getFrequencyUGen().setValue(val * val * 10000.0f + 100.0f);
        val = decider.getStateFract(next++);
        this.lpFilt.getResUGen().setValue(val * 0.4f + 0.5f);
        val = decider.getStateFract(next++);
        this.out1.getDelayUGen().setValue(val * val * 2000.0f + 500.0f);
        val = decider.getStateFract(next++);
        this.out2.getDelayUGen().setValue(val * val * 2000.0f + 500.0f);
        val = decider.getStateFract(next++);
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

