/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.WavePlayer;

public class OscbankSoundEvent2
implements DeciderSoundEvent {
    public static Slider staticGain;
    int numOscs = 5;
    float changeLevel;
    int last;
    WavePlayer lfo1;
    WavePlayer lfo2;
    WavePlayer[] oscs;
    Gain[] gains;
    Glide[] gainGlides;
    Glide[] freqGlides;
    Gain[] lfoGains;
    Glide[] lfoGainGlides;
    Envelope masterGain;
    Gain master;
    float maxVol = 1.0f / (float)this.numOscs * 0.4f;
    BiquadFilter bf;

    @Override
    public void init() {
    }

    public void init(UGen output) {
        this.lfoGainGlides = new Glide[this.numOscs];
        this.freqGlides = new Glide[this.numOscs];
        this.gainGlides = new Glide[this.numOscs];
        this.lfoGains = new Gain[this.numOscs];
        this.gains = new Gain[this.numOscs];
        this.oscs = new WavePlayer[this.numOscs];
        AudioContext ac = output.getContext();
        this.masterGain = new Envelope(ac, this.maxVol);
        this.master = new Gain(ac, 1, this.masterGain);
        this.bf = new BiquadFilter(ac, 1);
        this.bf.setFrequency(7000.0f);
        this.bf.setQ(0.1f);
        this.lfo1 = new WavePlayer(ac, 0.1f, Buffer.SINE);
        this.lfo2 = new WavePlayer(ac, 3.0f, Buffer.SAW);
        int i = 0;
        while (i < this.numOscs) {
            this.lfoGainGlides[i] = new Glide(ac, 0.0f);
            this.freqGlides[i] = new Glide(ac, 500.0f, 10.0f);
            this.gainGlides[i] = new Glide(ac, 0.0f);
            this.lfoGains[i] = new Gain(ac, 1, this.lfoGainGlides[i]);
            Function f = new Function(new UGen[]{this.gainGlides[i], this.lfo1, this.lfoGains[i]}){

                @Override
                public float calculate() {
                    return this.x[0] * (1.0f + this.x[1] * this.x[2]);
                }
            };
            this.gains[i] = new Gain(ac, 1, f);
            Function f2 = new Function(new UGen[]{this.freqGlides[i], this.lfoGains[i], this.lfo2}){

                @Override
                public float calculate() {
                    return this.x[0] * (1.0f + 50.0f * (this.x[1] * this.x[2]));
                }
            };
            this.oscs[i] = new WavePlayer(ac, f2, Buffer.SQUARE);
            this.gains[i].addInput(this.oscs[i]);
            this.master.addInput(this.gains[i]);
            ++i;
        }
        this.bf.addInput(this.master);
        if (staticGain == null) {
            staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
        }
        Gain main = new Gain(ac, 2, staticGain);
        main.addInput(this.bf);
        ac.out.addInput(main);
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        if (this.lfo1 == null) {
            this.init(output);
        }
        if (this.last != thisIndex) {
            this.changeLevel += 0.05f;
        }
        if (this.changeLevel > 1.0f) {
            this.changeLevel = 1.0f;
        }
        this.changeLevel *= 0.9f;
        this.last = thisIndex;
        if (decider.getStateFract(0) < 0.1f) {
            int he = decider.getNumHiddenElements();
            int i = 0;
            while (i < this.numOscs) {
                this.lfoGainGlides[i].setValue(decider.getStateFract(i));
                this.gainGlides[i].setValue(this.changeLevel * decider.getStateFract(i + this.numOscs));
                this.freqGlides[i].setValue(Pitch.mtof(Pitch.forceToScale((int)(decider.getStateFract(i + 2 * this.numOscs - 1) * decider.getStateFract(i + 2 * this.numOscs) * 48.0f + 38.0f), Pitch.dorian)));
                ++i;
            }
        }
        this.masterGain.clear();
        this.masterGain.addSegment(this.maxVol, 10.0f);
        this.masterGain.addSegment(0.0f, 20000.0f);
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

