/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.SamplePlayer;

public class PegMashSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    int lastIndex;
    int count;
    BiquadFilter bf;

    static {
        SampleManager.group("sax", String.valueOf(System.getProperty("user.home")) + "/Music/Audio/Samples/Peg Piano/chopped", 100);
    }

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        BiquadFilter result = null;
        AudioContext ac = output.getContext();
        if (this.bf == null) {
            this.bf = new BiquadFilter(ac, 2);
            this.bf.setQ(3.0f);
            this.bf.setFrequency(1000.0f);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(this.bf);
            output.addInput(main);
            result = this.bf;
        }
        int next = 0;
        this.bf.setFrequency(200.0f + 5000.0f * decider.getStateFract(next++));
        if (this.count % 2 == 0) {
            if (thisIndex != this.lastIndex) {
                Sample s = SampleManager.fromGroup("sax", thisIndex);
                SamplePlayer sp = null;
                if (Math.random() < (double)0.3f) {
                    GranularSamplePlayer gsp = new GranularSamplePlayer(ac, s);
                    gsp.getGrainIntervalUGen().setValue(30.0f);
                    gsp.getGrainSizeUGen().setValue(70.0f);
                    gsp.getRandomnessUGen().setValue(0.001f);
                    sp = gsp;
                    sp.getPitchUGen().setValue(this.randomPitch());
                } else {
                    sp = new SamplePlayer(ac, s);
                }
                if (Math.random() < (double)0.3f) {
                    sp.getRateUGen().setValue(this.randomPitch() / 2.0f);
                    sp.setPosition(200.0);
                } else {
                    sp.getRateUGen().setValue(-this.randomPitch() * 2.0f);
                    sp.setPosition(s.getLength() - 100.0);
                }
                sp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
                Envelope e = new Envelope(ac, 0.0f);
                Gain g = new Gain(ac, 2, e);
                e.addSegment(0.5f, 100.0f);
                e.addSegment(0.2f, 1000.0f * (float)Math.random());
                e.addSegment(0.5f, 2000.0f, new KillTrigger(g));
                g.addInput(sp);
                this.bf.addInput(g);
                System.out.println("playing " + s);
            }
            this.lastIndex = thisIndex;
        }
        ++this.count;
        return result;
    }

    private float randomPitch() {
        return (float)Math.pow(2.0, (int)(Math.random() * 5.0) + 1);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

