/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.WavePlayer;

public class PianoTinkleSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    PolyLimit master;
    Glide filterFreq;
    Glide lfoFreq;
    Glide pitch;
    Glide lfoGain;
    Glide lfoCentre;
    Function lfo;
    boolean doLoop;
    int lastIndex = 0;
    int count = 0;
    int adder;

    static {
        SampleManager.group("crisis", String.valueOf(System.getProperty("user.home")) + "/Music/Audio/Samples/Iowa/Piano Trimmed/ff");
    }

    @Override
    public void init() {
    }

    public void init(UGen output) {
        if (this.master == null) {
            AudioContext ac = output.getContext();
            this.master = new PolyLimit(ac, 2, 5);
            BiquadFilter bq = new BiquadFilter(ac, 2);
            bq.setQ(0.99f);
            this.filterFreq = new Glide(ac, 0.0f);
            bq.setFrequency(this.filterFreq);
            this.pitch = new Glide(ac, 0.0f);
            bq.addInput(this.master);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(bq);
            output.addInput(main);
            this.lfoFreq = new Glide(ac, 0.0f);
            this.lfoGain = new Glide(ac, 0.0f);
            this.lfoCentre = new Glide(ac, 0.0f);
            WavePlayer lfoSource = new WavePlayer(ac, this.lfoFreq, Buffer.SINE);
            this.lfo = new Function(new UGen[]{lfoSource, this.lfoGain, this.lfoCentre}){

                @Override
                public float calculate() {
                    return this.x[0] * this.x[1] + this.x[2];
                }
            };
        }
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider d) {
        Gain result = null;
        AudioContext ac = output.getContext();
        this.init(output);
        this.updateFromDecider(d);
        if (this.count % 10 == 0) {
            if (thisIndex != this.lastIndex) {
                Sample s = SampleManager.fromGroup("crisis", thisIndex + this.adder);
                SamplePlayer sp = null;
                if (Math.random() < (double)0.9f) {
                    sp = new SamplePlayer(ac, s);
                } else {
                    GranularSamplePlayer gsp = new GranularSamplePlayer(ac, s);
                    gsp.getGrainSizeUGen().setValue(50.0f);
                    gsp.getGrainIntervalUGen().setValue(30.0f);
                    sp = gsp;
                }
                if (this.doLoop) {
                    sp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
                    sp.getLoopEndUGen().setValue(100.0f);
                    sp.getLoopEndUGen().setValue((float)(Math.random() * Math.random()) * 1000.0f + 200.0f);
                }
                if (Math.random() < (double)0.1f) {
                    sp.setRate(this.lfo);
                } else if (Math.random() < (double)0.1f) {
                    sp.setRate(this.pitch);
                }
                Envelope myEnv = new Envelope(ac, 0.2f);
                Gain g = new Gain(ac, s.getNumChannels(), myEnv);
                myEnv.addSegment(0.2f, (float)Math.random() * 4000.0f + 1000.0f);
                myEnv.addSegment(0.0f, 1000.0f, new KillTrigger(g));
                g.addInput(sp);
                this.master.addInput(g);
                result = g;
            }
            this.lastIndex = thisIndex;
        }
        ++this.count;
        return result;
    }

    private void updateFromDecider(Decider d) {
        int index = 0;
        float next = d.getStateFract(index++);
        if (Math.random() < (double)next) {
            next = d.getStateFract(index++);
            this.filterFreq.setValue(next * 10000.0f + 500.0f);
        } else {
            next = d.getStateFract(index++);
            this.filterFreq.setValue(next * 10000.0f + 5000.0f);
        }
        next = d.getStateFract(index++);
        this.pitch.setValue(next * next * 0.2f + 0.5f);
        next = d.getStateFract(index++);
        this.adder = (int)(100.0f * next);
        next = d.getStateFract(index++);
        this.doLoop = Math.random() < (double)(next * next);
        next = d.getStateFract(index++);
        this.lfoCentre.setValue(next * 0.5f + 1.0f);
        next = d.getStateFract(index++);
        this.lfoGain.setValue(next * next);
        next = d.getStateFract(index++);
        this.lfoFreq.setValue(next * next * 30.0f + 0.4f);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

