/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.Reverb;
import net.beadsproject.beads.ugens.SamplePlayer;

public class PianoTwistSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    private GranularSamplePlayer gsp;
    private Envelope gainEnv;
    private Glide rate;
    private Glide pitch;
    private Glide rand;
    private Glide panRand;
    private Glide bandFreq;
    private Gain gain;
    private Gain master;
    private int last = -1;

    static {
        SampleManager.sample("pnno", "/Users/ollie/Music/Audio/Samples/Tris Piano/piano snip 1.aif");
    }

    @Override
    public void init() {
    }

    private void setup(UGen output) {
        AudioContext ac = output.getContext();
        if (staticGain == null) {
            staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
        }
        this.gsp = new GranularSamplePlayer(ac, SampleManager.sample("pnno"));
        this.gsp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
        this.rate = new Glide(ac, 0.0f, 200.0f);
        this.gsp.setRate(this.rate);
        this.pitch = new Glide(ac, 1.0f, 20.0f);
        this.gsp.setPitch(this.pitch);
        this.rand = new Glide(ac, 0.0f);
        this.gsp.setRandomness(this.rand);
        this.panRand = new Glide(ac, 0.0f);
        this.gsp.setRandomPan(this.panRand);
        this.bandFreq = new Glide(ac, 0.0f, 200.0f);
        BiquadFilter bf = new BiquadFilter(ac, 2);
        bf.setFrequency(this.bandFreq);
        bf.setQ(0.5f);
        this.gainEnv = new Envelope(ac, 0.0f);
        this.gain = new Gain(ac, 2, this.gainEnv);
        bf.addInput(this.gsp);
        Glide gtemp = new Glide(ac, 10.0f);
        this.gsp.setGrainSize(gtemp);
        gtemp = new Glide(ac, 10.0f);
        this.gsp.setGrainInterval(gtemp);
        gtemp = new Glide(ac, 0.01f);
        this.gsp.setRandomness(gtemp);
        Reverb r = new Reverb(ac);
        r.setLateReverbLevel(0.5f);
        r.setSize(1.0f);
        r.setEarlyReflectionsLevel(0.0f);
        r.addInput(this.gsp);
        this.gain.addInput(r);
        this.gain.addInput(bf);
        this.master = new Gain(ac, 2, staticGain);
        this.master.addInput(this.gain);
        if (staticGain == null) {
            staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
        }
        Gain main = new Gain(ac, 2, staticGain);
        main.addInput(this.master);
        output.addInput(main);
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        boolean init = false;
        if (this.gsp == null) {
            this.setup(output);
            init = true;
        }
        int next = 0;
        float currentGain = this.gainEnv.getValue();
        currentGain = Math.min(0.9f, currentGain + 0.5f);
        this.gainEnv.setValue(currentGain);
        this.gainEnv.addSegment(0.0f, 5000.0f);
        if (thisIndex != this.last) {
            float targetRate = -0.01f;
            if (thisIndex % 20 > 15) {
                targetRate = (float)Math.pow((float)(thisIndex % 100) / 100.0f, 2.0) * 1.0f;
            }
            this.rate.setValue(targetRate);
            float targetPitch = (float)Math.pow(2.0, thisIndex % 3 - 2);
            int n = next++;
            if (decider.getStateFract(n) < 0.01f) {
                this.pitch.setValue(targetPitch);
            }
            this.rand.setValue((float)Math.pow(DSEControl.getParameterA(decider), 1.0) * 0.05f);
            this.panRand.setValue(DSEControl.getParameterB(decider));
            if (DSEControl.getProbA(decider, 0.05f)) {
                double newPos = this.gsp.getSample().getLength() * (double)(thisIndex % 128) / 128.0;
                this.gsp.setPosition(newPos);
            }
            int n2 = next++;
            if (decider.getStateFract(n2) < 0.001f) {
                this.gsp.setPosition(this.gsp.getSample().getLength() * (double)decider.getStateFract(next++));
            }
        }
        this.last = thisIndex;
        float interval = DSEControl.getParameterC(decider) * 60.0f + 20.0f;
        float size = interval * (DSEControl.getParameterD(decider) * 100.0f + 2.0f);
        this.gsp.getGrainIntervalUGen().setValue(interval);
        this.gsp.getGrainSizeUGen().setValue(size);
        this.bandFreq.setValue(DSEControl.getFilterFreq(decider) * 10000.0f + 1000.0f);
        this.gsp.getRandomnessUGen().setValue(decider.getStateFract(next++) * decider.getStateFract(next++));
        return init ? this.gain : null;
    }

    @Override
    public void destroy() {
        if (this.master != null) {
            this.master.kill();
        }
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/bird_decider"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

