/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_3;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.Mult;
import net.beadsproject.beads.ugens.Noise;
import net.beadsproject.beads.ugens.WavePlayer;

public class PlainToneEvent
implements DeciderSoundEvent {
    public static final int[] seq;
    public static final int[] scale;
    public static Slider staticGain;
    private Gain master;
    private Gain gain;
    private Envelope gainLevel;
    private Glide modRatio;
    private Glide nzeRatio;
    private Glide carrierFreq;
    private Glide modAmnt;
    private int lastIndex = 0;
    private int step = 0;

    static {
        int[] nArray = new int[7];
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 5;
        nArray[6] = 10;
        seq = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 9;
        nArray2[6] = 10;
        scale = nArray2;
    }

    @Override
    public void init() {
    }

    private void setup(UGen output) {
        AudioContext ac = output.getContext();
        this.gainLevel = new Envelope(ac, 0.1f);
        this.gain = new Gain(ac, 1, this.gainLevel);
        this.carrierFreq = new Glide(ac, 0.0f, 2.0f);
        this.modRatio = new Glide(ac, 0.5f, 2.0f);
        Mult modFreq = new Mult(ac, this.carrierFreq, (UGen)this.modRatio);
        WavePlayer mod = new WavePlayer(ac, modFreq, Buffer.SQUARE);
        Noise modNze = new Noise(ac);
        this.nzeRatio = new Glide(ac, 0.0f, 2000.0f);
        this.modAmnt = new Glide(ac, 0.0f, 20.0f);
        Function theMod = new Function(new UGen[]{this.carrierFreq, mod, modNze, this.nzeRatio, this.modAmnt}){

            @Override
            public float calculate() {
                return this.x[0] + 0.1f * (this.x[1] * (1.0f - this.x[3]) + 0.02f * this.x[3] * this.x[2]) * this.x[4];
            }
        };
        Sample s = SampleManager.sample("audio/2014/1000.mp3");
        Buffer buf = new Buffer(8192);
        float[] frame = new float[s.getNumChannels()];
        int i = 0;
        while (i < buf.buf.length) {
            s.getFrame(i + (int)s.msToSamples(150.0), frame);
            buf.buf[i] = frame[0];
            ++i;
        }
        WavePlayer carrier = new WavePlayer(ac, theMod, buf);
        this.gain.addInput(carrier);
        if (staticGain == null) {
            staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
        }
        this.master = new Gain(ac, 2, staticGain);
        output.addInput(this.master);
        this.master.addInput(this.gain);
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        boolean init = false;
        if (this.gain == null) {
            this.setup(output);
            init = true;
        }
        int i = 0;
        int n = ++i;
        int n2 = ++i;
        ++i;
        if (decider.getStateFract(n) * decider.getStateFract(n2) > 0.01f) {
            int pitch = thisIndex / 5 % 10;
            int n3 = i++;
            if (decider.getStateFract(n3) > 0.5f) {
                pitch = seq[this.step];
                this.step = (this.step + 1) % seq.length;
            }
            pitch = Pitch.forceToScale(pitch, scale);
            int n4 = i++;
            if (decider.getStateFract(n4) < 0.001f) {
                PlainToneEvent.scale[5] = scale[5] == 8 ? 9 : 8;
            }
            int reg = thisIndex / 100 % 5;
            float freqval = Pitch.mtof(pitch += reg * 12);
            this.carrierFreq.setValue(freqval / 8192.0f);
            float modRVal = (float)Math.pow(thisIndex % 40 / 10, 1.0);
            int n5 = i++;
            if (decider.getStateFract(n5) > 0.5f) {
                modRVal += decider.getStateFract(i++) * 0.1f;
            }
            this.modRatio.setValue(modRVal / 8192.0f);
            this.modAmnt.setValue((1.0f - decider.getStateFract(i++)) * (1.0f - decider.getStateFract(i++)) * 600.0f);
            this.nzeRatio.setValue(decider.getStateFract(i++) * decider.getStateFract(i++) * decider.getStateFract(i++) * 0.9f);
            int thisIndexCoarse = thisIndex / 10;
            if (thisIndexCoarse != this.lastIndex) {
                this.gainLevel.clear();
                this.gainLevel.addSegment(2.0f, 5000.0f * decider.getStateFract(i++) * decider.getStateFract(i++) * decider.getStateFract(i++));
                this.gainLevel.addSegment(0.0f, 1000.0f);
            }
            this.lastIndex = thisIndexCoarse;
        }
        return init ? this.gain : null;
    }

    @Override
    public void destroy() {
        if (this.master != null) {
            this.master.kill();
        }
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

