/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.util.ArrayList;
import java.util.List;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.analysis.SegmentMaker;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.core.UGen;

public abstract class AudioSegmenter
extends UGen
implements SegmentMaker {
    private ArrayList<FeatureExtractor<?, float[]>> listeners = new ArrayList();
    private List<SegmentListener> segmentListeners = new ArrayList<SegmentListener>();

    public AudioSegmenter(AudioContext audioContext) {
        super(audioContext, 1, 0);
    }

    public void addListener(FeatureExtractor<?, float[]> featureExtractor) {
        this.listeners.add(featureExtractor);
    }

    @Override
    public void addSegmentListener(SegmentListener segmentListener) {
        this.segmentListeners.add(segmentListener);
    }

    @Override
    public void removeSegmentListener(SegmentListener segmentListener) {
        this.segmentListeners.add(segmentListener);
    }

    protected void segment(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        if (fArray != null) {
            for (FeatureExtractor object : this.listeners) {
                object.process(timeStamp, timeStamp2, fArray);
            }
        }
        for (SegmentListener segmentListener : this.segmentListeners) {
            segmentListener.newSegment(timeStamp, timeStamp2);
        }
    }

    public abstract void resetTimeStamp();

    public abstract void setBeginningTimeStamp(TimeStamp var1);

    public abstract void setLastTimeStamp(TimeStamp var1);

    @Override
    public String toString() {
        String string = "Segmenter: " + this.getClass().getSimpleName();
        for (FeatureExtractor<?, float[]> featureExtractor : this.listeners) {
            string = string + "\n    " + featureExtractor.getName();
        }
        return string;
    }
}

