/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import net.beadsproject.beads.analysis.FeatureSet;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;

public class FeatureManager {
    private static final Map<Sample, FeatureSet> featureSets = new Hashtable<Sample, FeatureSet>();
    private static boolean verbose = true;

    public static void setFeaturesForSample(Sample sample, FeatureSet featureSet) {
        featureSets.put(sample, featureSet);
    }

    public static FeatureSet featuresForSample(Sample sample) {
        if (featureSets.containsKey(sample)) {
            return featureSets.get(sample);
        }
        FeatureSet featureSet = FeatureSet.forSample(sample);
        if (featureSet != null) {
            featureSets.put(sample, featureSet);
            if (verbose) {
                System.out.println("Loaded features for " + sample.getFileName());
            }
        } else if (verbose) {
            System.out.println("Could not find features for " + sample.getFileName());
        }
        return featureSet;
    }

    public static FeatureSet featuresForSampleIfLoaded(Sample sample) {
        if (featureSets.containsKey(sample)) {
            return featureSets.get(sample);
        }
        return null;
    }

    public static void featuresForGroup(String string) {
        ArrayList<Sample> arrayList = SampleManager.getGroup(string);
        if (arrayList != null) {
            for (Sample sample : arrayList) {
                FeatureManager.featuresForSample(sample);
            }
        }
    }

    public static void removeSample(Sample sample) {
        if (featureSets.containsKey(sample)) {
            featureSets.remove(sample);
        }
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }
}

