/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class Frequency
extends FeatureExtractor<Float, float[]> {
    static final int FIRSTBAND = 3;
    private float bin2hz;
    private int bufferSize = -1;
    private float sampleRate;

    public Frequency(float f) {
        this.sampleRate = f;
        this.features = null;
    }

    @Override
    public synchronized void process(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        if (this.bufferSize != fArray.length) {
            this.bufferSize = fArray.length;
            this.bin2hz = this.sampleRate / (float)(2 * this.bufferSize);
        }
        this.features = null;
        double d = -1.0;
        int n = 0;
        for (int i = 3; i < fArray.length; ++i) {
            double d2 = fArray[i];
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        double d3 = fArray[n];
        double d4 = n <= 0 ? (double)fArray[n] : (double)fArray[n - 1];
        double d5 = n < fArray.length - 1 ? (double)fArray[n + 1] : (double)fArray[n];
        double d6 = (d5 + d4) / 2.0 - d3;
        double d7 = (d4 - d5) / (4.0 * d6);
        this.features = Float.valueOf((float)((double)this.bin2hz * ((double)n + d7)));
        this.forward(timeStamp, timeStamp2);
    }

    @Override
    public String[] getFeatureDescriptions() {
        return new String[]{"frequency"};
    }
}

