/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import java.util.Arrays;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class MFCC
extends FeatureExtractor<float[], float[]> {
    private double[][] DCTcoeffs;
    private int inputLength;

    public MFCC(int n) {
        this.setNumberOfFeatures(n);
        this.features = new float[this.numFeatures];
        this.featureDescriptions = new String[this.numFeatures];
        for (int i = 0; i < n; ++i) {
            this.featureDescriptions[i] = i < 9 ? "mfcc0" + (i + 1) : "mfcc" + (i + 1);
        }
    }

    @Override
    public void setNumberOfFeatures(int n) {
        super.setNumberOfFeatures(n);
        this.inputLength = -1;
    }

    private void setupDCTcoeffs() {
        double d = Math.sqrt(2.0 / (double)this.inputLength);
        this.DCTcoeffs = new double[this.inputLength][((float[])this.features).length];
        for (int i = 0; i < this.inputLength; ++i) {
            for (int j = 0; j < ((float[])this.features).length; ++j) {
                this.DCTcoeffs[i][j] = d * Math.cos(Math.PI * (double)(j + 1) * ((double)i + 0.5) / (double)this.inputLength);
            }
        }
    }

    @Override
    public void process(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        int n;
        Arrays.fill((float[])this.features, 0.0f);
        float[] fArray2 = new float[fArray.length];
        for (n = 0; n < fArray.length; ++n) {
            fArray2[n] = fArray[n];
        }
        if (fArray.length != this.inputLength) {
            this.inputLength = fArray.length;
            this.setupDCTcoeffs();
        }
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = fArray2[n] / 10.0f;
            for (int i = 0; i < ((float[])this.features).length; ++i) {
                float[] fArray3 = (float[])this.features;
                int n2 = i;
                fArray3[n2] = fArray3[n2] + (float)(this.DCTcoeffs[n][i] * (double)fArray2[n]);
            }
        }
        this.forward(timeStamp, timeStamp2);
    }
}

