/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.featureextractors.FFT;
import net.beadsproject.beads.core.TimeStamp;

public class SpectralDifference
extends FeatureExtractor<Float, float[]> {
    private float[] previousSpectrum;
    private float minFreq;
    private float maxFreq;
    private float sampleRate;
    private DifferenceType differenceType = DifferenceType.POSITIVEMEANDIFFERENCE;
    private int lastBlockSize = 0;
    private int minBin;
    private int maxBin;

    public SpectralDifference(float f) {
        this(f, 0.0f, f);
    }

    public SpectralDifference(float f, float f2, float f3) {
        this.minFreq = f2;
        this.maxFreq = f3;
        this.sampleRate = f;
    }

    public void setFreqWindow(float f, float f2) {
        this.minFreq = f;
        this.maxFreq = f2;
    }

    public void setDifferenceType(DifferenceType differenceType) {
        this.differenceType = differenceType;
    }

    @Override
    public void process(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        int n = this.maxBin - this.minBin;
        if (this.lastBlockSize != fArray.length) {
            this.calcMaxAndMinBin(fArray.length);
            n = this.maxBin - this.minBin;
            if (n > 0) {
                this.previousSpectrum = new float[n];
            }
            this.lastBlockSize = fArray.length;
        }
        if (n > 0) {
            switch (this.differenceType) {
                case POSITIVERMS: {
                    this.features = Float.valueOf(this.positiveRms(fArray, this.minBin, this.previousSpectrum, 0, n));
                    break;
                }
                case RMS: {
                    this.features = Float.valueOf(this.rms(fArray, this.minBin, this.previousSpectrum, 0, n));
                    break;
                }
                case POSITIVEMEANDIFFERENCE: {
                    this.features = Float.valueOf(this.positiveMeanDifference(fArray, this.minBin, this.previousSpectrum, 0, n));
                    break;
                }
                case MEANDIFFERENCE: {
                    this.features = Float.valueOf(this.meanDifference(fArray, this.minBin, this.previousSpectrum, 0, n));
                }
            }
            System.arraycopy(fArray, this.minBin, this.previousSpectrum, 0, n);
        }
        this.forward(timeStamp, timeStamp2);
    }

    private float rms(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        float f = 0.0f;
        for (int i = 0; i < n3; ++i) {
            float f2 = fArray[n + i] - fArray2[n2 + i];
            f += f2 * f2;
        }
        return (float)Math.sqrt(f / (float)n3);
    }

    private float positiveRms(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        float f = 0.0f;
        for (int i = 0; i < n3; ++i) {
            float f2 = fArray[n + i] - fArray2[n2 + i];
            if (!(f2 >= 0.0f)) continue;
            f += f2 * f2;
        }
        return (float)Math.sqrt(f / (float)n3);
    }

    private float meanDifference(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        float f = 0.0f;
        for (int i = 0; i < n3; ++i) {
            f += fArray[n + i] - fArray2[n2 + i];
        }
        return f / (float)n3;
    }

    private float positiveMeanDifference(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        float f = 0.0f;
        for (int i = 0; i < n3; ++i) {
            if (!(fArray[n + i] > fArray2[n2 + i])) continue;
            f += fArray[n + i] - fArray2[n2 + i];
        }
        return f / (float)n3;
    }

    private void calcMaxAndMinBin(int n) {
        this.minBin = Math.min(n - 1, Math.max(0, Math.round(FFT.binNumber(this.sampleRate, n, this.minFreq))));
        this.maxBin = Math.min(n - 1, Math.max(0, Math.round(FFT.binNumber(this.sampleRate, n, this.maxFreq))));
    }

    public static enum DifferenceType {
        POSITIVERMS,
        RMS,
        POSITIVEMEANDIFFERENCE,
        MEANDIFFERENCE;

    }
}

