/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Random;

public final class AudioUtils {
    public static Random rng = new Random();

    public static final void shortToFloat(float[] fArray, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            fArray[i] = (float)((double)sArray[i] / 32768.0);
        }
    }

    public static final void floatToShort(short[] sArray, float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            sArray[i] = (short)(32767.0 * (double)fArray[i]);
        }
    }

    public static final void floatToByte(byte[] byArray, float[] fArray, boolean bl) {
        AudioUtils.floatToByte(byArray, 0, fArray, 0, fArray.length, bl);
    }

    public static final void floatToByte(byte[] byArray, int n, float[] fArray, int n2, int n3, boolean bl) {
        int n4 = Math.min(n3, fArray.length);
        int n5 = n;
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                short s = (short)(32767.0 * (double)Math.min(Math.max(fArray[i + n2], -1.0f), 1.0f));
                byArray[n5++] = (byte)(s >> 8 & 0xFF);
                byArray[n5++] = (byte)(s & 0xFF);
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                short s = (short)(32767.0 * (double)fArray[i + n2]);
                byArray[n5++] = (byte)(s & 0xFF);
                byArray[n5++] = (byte)(s >> 8 & 0xFF);
            }
        }
    }

    public static final void byteToFloat(float[] fArray, byte[] byArray, boolean bl) {
        AudioUtils.byteToFloat(fArray, byArray, bl, fArray.length);
    }

    public static final void byteToFloat(float[] fArray, byte[] byArray, boolean bl, int n) {
        AudioUtils.byteToFloat(fArray, byArray, bl, 0, n);
    }

    public static final void byteToFloat(float[] fArray, byte[] byArray, boolean bl, int n, int n2) {
        AudioUtils.byteToFloat(fArray, byArray, bl, n, 0, n2);
    }

    public static final void byteToFloat(float[] fArray, byte[] byArray, boolean bl, int n, int n2, int n3) {
        if (bl) {
            int n4 = n;
            int n5 = Math.min(fArray.length, n2 + n3);
            for (int i = n2; i < n5; ++i) {
                float f = (float)(byArray[n4 + 0] << 8 | byArray[n4 + 1] & 0xFF) / 32768.0f;
                n4 += 2;
                fArray[i] = f;
            }
        } else {
            int n6 = n;
            int n7 = Math.min(fArray.length, n2 + n3);
            for (int i = n2; i < n7; ++i) {
                float f = (float)(byArray[n6] & 0xFF | byArray[n6 + 1] << 8) / 32768.0f;
                n6 += 2;
                fArray[i] = f;
            }
        }
    }

    public static final void deinterleave(float[] fArray, int n, int n2, float[][] fArray2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray2[j][i] = fArray[n3++];
            }
        }
    }

    public static final void interleave(float[][] fArray, int n, int n2, float[] fArray2) {
        int n3 = 0;
        for (int i = 0; n3 < fArray2.length && i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray2[n3++] = fArray[j][i];
            }
        }
    }

    public static final void interleave(float[][] fArray, int n, int n2, int n3, float[] fArray2) {
        int n4 = 0;
        for (int i = n3; n4 < fArray2.length && i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray2[n4++] = fArray[j][i];
            }
        }
    }

    public static final void stretchBuffer(float[][] fArray, float[][] fArray2) {
        int n = Math.min(fArray.length, fArray2.length);
        double d = ((double)fArray[0].length - 1.0) / ((double)fArray2[0].length - 1.0);
        for (int i = 0; i < n; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            if (fArray3.length == 1 || fArray4.length == 1) {
                fArray4[0] = fArray3[0];
                continue;
            }
            fArray4[0] = fArray3[0];
            fArray4[fArray4.length - 1] = fArray3[fArray3.length - 1];
            int n2 = -1;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int j = 1; j < fArray4.length - 1; ++j) {
                int n3 = (int)Math.floor(d5 += d);
                if (n3 != n2) {
                    n2 = n3;
                    d2 = fArray3[n2];
                    d3 = fArray3[n2 + 1];
                    d4 = d3 - d2;
                }
                fArray4[j] = (float)(d2 + d4 * (d5 - (double)n3));
            }
        }
    }

    public static final void reverseBuffer(float[][] fArray) {
        for (float[] fArray2 : fArray) {
            int n = 0;
            for (int i = fArray2.length - 1; n < i; ++n, --i) {
                float f = fArray2[n];
                fArray2[n] = fArray2[i];
                fArray2[i] = f;
            }
        }
    }

    public static double fastPow01(double d, double d2) {
        double d3 = Math.max(0.0, Math.min(1.0, d));
        int n = (int)(Double.doubleToLongBits(d3) >> 32);
        int n2 = (int)(d2 * (double)(n - 1072632447) + 1.072632447E9);
        return Math.max(0.0, Math.min(1.0, Double.longBitsToDouble((long)n2 << 32)));
    }

    public static URL urlFromString(String string) {
        URL uRL = null;
        uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            File file = new File(string);
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return uRL;
    }

    public static File fileFromURL(URL uRL) {
        File file = null;
        try {
            file = new File(URLDecoder.decode(uRL.getPath(), "UTF-8"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public static File fileFromString(String string) {
        return AudioUtils.fileFromURL(AudioUtils.urlFromString(string));
    }
}

