/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

public abstract class Bead {
    private boolean paused = false;
    private boolean deleted = false;
    private Bead killListener;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        String string = this.name;
        if (string != null) {
            return this.getClass().toString() + " name=" + string;
        }
        return this.getClass().toString();
    }

    public final void message(Bead bead) {
        if (!this.paused) {
            this.messageReceived(bead);
        }
    }

    protected void messageReceived(Bead bead) {
    }

    public void start() {
        this.paused = false;
    }

    public void kill() {
        if (!this.deleted) {
            this.deleted = true;
            Bead bead = this.killListener;
            if (bead != null) {
                bead.message(this);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause(boolean bl) {
        this.paused = bl;
    }

    public void setKillListener(Bead bead) {
        this.killListener = bead;
    }

    public Bead getKillListener() {
        return this.killListener;
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

