/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;

public abstract class UGen
extends Bead {
    protected AudioContext context;
    protected int ins;
    protected int outs;
    protected float[][] bufIn;
    protected float[][] bufOut;
    protected int bufferSize;
    private ArrayList<BufferPointer>[] inputsAtChannel;
    private ArrayList<UGen> dependents = new ArrayList();
    private boolean noInputs = true;
    private long lastTimeStep = -1L;
    private boolean timerMode = false;
    private long timeTakenLastUpdate;
    private long timeTemp = 0L;
    protected OutputInitializationRegime outputInitializationRegime = OutputInitializationRegime.JUNK;
    protected OutputPauseRegime outputPauseRegime = OutputPauseRegime.ZERO;
    private static Hashtable<Class<?>, Hashtable<String, Method>> envelopeGetterMethods = new Hashtable();

    public UGen(AudioContext audioContext) {
        this(audioContext, 0, 0);
    }

    public UGen(AudioContext audioContext, int n) {
        this(audioContext, 0, n);
    }

    public UGen(AudioContext audioContext, int n, int n2) {
        this.setIns(n);
        this.setOuts(n2);
        this.setContext(audioContext);
    }

    private void setContext(AudioContext audioContext) {
        this.context = audioContext;
        if (audioContext != null) {
            this.bufferSize = audioContext.getBufferSize();
            this.setupInputBuffer();
            this.setupOutputBuffer();
            this.zeroIns();
            this.zeroOuts();
        } else {
            this.bufIn = null;
            this.bufOut = null;
        }
    }

    public AudioContext getContext() {
        return this.context;
    }

    private synchronized void setIns(int n) {
        this.ins = n;
        this.inputsAtChannel = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            this.inputsAtChannel[i] = new ArrayList();
        }
    }

    public int getIns() {
        return this.ins;
    }

    private void setOuts(int n) {
        this.outs = n;
    }

    public int getOuts() {
        return this.outs;
    }

    private void setupInputBuffer() {
        this.bufIn = new float[this.ins][];
    }

    private void setupOutputBuffer() {
        this.bufOut = new float[this.outs][];
    }

    public void zeroOuts() {
        for (int i = 0; i < this.outs; ++i) {
            this.bufOut[i] = this.context.getZeroBuf();
        }
    }

    public void zeroIns() {
        for (int i = 0; i < this.ins; ++i) {
            this.bufIn[i] = this.context.getZeroBuf();
        }
    }

    protected void setOutsToPause() {
        switch (this.outputPauseRegime) {
            case ZERO: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = this.context.getZeroBuf();
                }
                break;
            }
            case RETAIN: {
                break;
            }
            case NULL: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = null;
                }
                break;
            }
        }
    }

    protected void initializeOuts() {
        switch (this.outputInitializationRegime) {
            case JUNK: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = this.context.getBuf();
                }
                break;
            }
            case ZERO: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = this.context.getCleanBuf();
                }
                break;
            }
            case NULL: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = null;
                }
                break;
            }
            case RETAIN: {
                break;
            }
            default: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = null;
                }
            }
        }
    }

    private synchronized void pullInputs() {
        block11: {
            int n;
            block10: {
                Object object;
                int n2 = this.dependents.size();
                for (n = 0; n < n2; ++n) {
                    object = this.dependents.get(n);
                    if (((Bead)object).isDeleted()) {
                        this.dependents.remove(n);
                        --n;
                        --n2;
                        continue;
                    }
                    ((UGen)object).update();
                }
                if (this.noInputs) break block10;
                this.noInputs = true;
                for (n = 0; n < this.inputsAtChannel.length; ++n) {
                    n2 = this.inputsAtChannel[n].size();
                    this.bufIn[n] = this.context.getZeroBuf();
                    if (n2 == 1) {
                        object = this.inputsAtChannel[n].get(0);
                        if (((BufferPointer)object).ugen.isDeleted()) {
                            this.removeInputAtChannel(n, (BufferPointer)object);
                            continue;
                        }
                        ((BufferPointer)object).ugen.update();
                        this.noInputs = false;
                        this.bufIn[n] = ((BufferPointer)object).getBuffer();
                        if (this.bufIn[n] != null) continue;
                        this.bufIn[n] = this.context.getBuf();
                        float[] fArray = this.bufIn[n];
                        for (int i = 0; i < this.bufferSize; ++i) {
                            fArray[i] = ((BufferPointer)object).get(i);
                        }
                        continue;
                    }
                    if (n2 == 0) continue;
                    this.bufIn[n] = this.context.getCleanBuf();
                    object = this.bufIn[n];
                    for (int i = 0; i < n2; ++i) {
                        BufferPointer bufferPointer = this.inputsAtChannel[n].get(i);
                        if (bufferPointer.ugen.isDeleted()) {
                            this.removeInputAtChannel(n, bufferPointer);
                            --n2;
                            --i;
                            continue;
                        }
                        bufferPointer.ugen.update();
                        this.noInputs = false;
                        for (int j = 0; j < this.bufferSize; ++j) {
                            Object object2 = object;
                            int n3 = j;
                            object2[n3] = object2[n3] + bufferPointer.get(j);
                        }
                    }
                }
                break block11;
            }
            if (this.ins == 0) break block11;
            for (n = 0; n < this.inputsAtChannel.length; ++n) {
                this.bufIn[n] = this.context.getZeroBuf();
            }
        }
    }

    public void update() {
        if (!this.isPaused()) {
            if (!this.isUpdated()) {
                if (this.timerMode) {
                    this.timeTemp = System.nanoTime();
                }
                this.lastTimeStep = this.context.getTimeStep();
                this.pullInputs();
                this.initializeOuts();
                this.calculateBuffer();
                if (this.timerMode) {
                    this.timeTakenLastUpdate = System.nanoTime() - this.timeTemp;
                }
            }
            if (this.isPaused()) {
                this.setOutsToPause();
            }
        }
    }

    public void printInputList() {
        for (int i = 0; i < this.inputsAtChannel.length; ++i) {
            System.out.print(this.inputsAtChannel[i].size() + " inputs: ");
            for (BufferPointer bufferPointer : this.inputsAtChannel[i]) {
                System.out.print(bufferPointer.ugen + ":" + bufferPointer.index + " ");
            }
            System.out.println();
        }
    }

    public synchronized void addInput(UGen uGen) {
        if (this.ins != 0 && uGen.outs != 0) {
            for (int i = 0; i < this.ins; ++i) {
                this.addInput(i, uGen, i % uGen.outs);
            }
        }
    }

    public synchronized void addInput(int n, UGen uGen, int n2) {
        this.inputsAtChannel[n].add(new BufferPointer(uGen, n2));
        this.noInputs = false;
    }

    public synchronized void crossfadeInput(UGen uGen, final UGen uGen2, float f) {
        this.removeAllConnections(uGen);
        Envelope envelope = new Envelope(this.context, 1.0f);
        Gain gain = new Gain(this.context, uGen.outs, envelope);
        envelope.addSegment(0.0f, f, new KillTrigger(gain));
        gain.addInput(uGen);
        this.addInput(gain);
        Envelope envelope2 = new Envelope(this.context, 0.0f);
        final Gain gain2 = new Gain(this.context, uGen2.outs, envelope2);
        envelope2.addSegment(1.0f, f, new Bead(){

            @Override
            public void messageReceived(Bead bead) {
                UGen.this.removeAllConnections(gain2);
                UGen.this.addInput(uGen2);
            }
        });
        gain2.addInput(uGen);
        this.addInput(gain2);
    }

    public synchronized void addDependent(UGen uGen) {
        this.dependents.add(uGen);
    }

    public synchronized void removeDependent(UGen uGen) {
        this.dependents.remove(uGen);
    }

    public synchronized void clearDependents() {
        this.dependents.clear();
    }

    public synchronized int getNumberOfConnectedUGens(int n) {
        return this.inputsAtChannel[n].size();
    }

    public synchronized int getNumberOfDependents() {
        return this.dependents.size();
    }

    public synchronized boolean containsInput(UGen uGen) {
        if (this.noInputs) {
            return false;
        }
        for (int i = 0; i < this.inputsAtChannel.length; ++i) {
            ArrayList arrayList = (ArrayList)this.inputsAtChannel[i].clone();
            for (BufferPointer bufferPointer : arrayList) {
                if (!uGen.equals(bufferPointer.ugen)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized Set<UGen> getConnectedInputs() {
        HashSet<UGen> hashSet = new HashSet<UGen>();
        for (int i = 0; i < this.ins; ++i) {
            for (BufferPointer bufferPointer : this.inputsAtChannel[i]) {
                hashSet.add(bufferPointer.ugen);
            }
        }
        return hashSet;
    }

    private void findEnvelopeGetterMethods() {
        Class<?> clazz = this.getClass();
        if (!envelopeGetterMethods.containsKey(clazz)) {
            Method[] methodArray;
            Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
            for (Method method : methodArray = clazz.getMethods()) {
                String string = method.getName();
                if (!string.startsWith("get") || !string.endsWith("UGen") || !method.getReturnType().equals(UGen.class)) continue;
                String string2 = string.substring(3, 3).toLowerCase() + string.substring(4, string.length() - 8);
                hashtable.put(string2, method);
            }
            envelopeGetterMethods.put(clazz, hashtable);
        }
    }

    public synchronized Map<String, UGen> getEnvelopes() {
        Hashtable<String, UGen> hashtable = new Hashtable<String, UGen>();
        this.findEnvelopeGetterMethods();
        Hashtable<String, Method> hashtable2 = envelopeGetterMethods.get(this.getClass());
        for (String string : hashtable2.keySet()) {
            Method method = hashtable2.get(string);
            try {
                hashtable.put(string, (UGen)method.invoke((Object)this, new Object[0]));
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    private synchronized void removeInputAtChannel(int n, BufferPointer bufferPointer) {
        this.inputsAtChannel[n].remove(bufferPointer);
    }

    public synchronized void removeAllConnections(UGen uGen) {
        if (!this.noInputs) {
            int n = 0;
            for (int i = 0; i < this.inputsAtChannel.length; ++i) {
                ArrayList arrayList = (ArrayList)this.inputsAtChannel[i].clone();
                for (BufferPointer bufferPointer : arrayList) {
                    if (uGen.equals(bufferPointer.ugen)) {
                        this.removeInputAtChannel(i, bufferPointer);
                        continue;
                    }
                    ++n;
                }
            }
            if (n == 0) {
                this.noInputs = true;
                this.zeroIns();
            }
        }
    }

    public synchronized boolean removeConnection(int n, UGen uGen, int n2) {
        if (!this.noInputs) {
            int n3 = 0;
            boolean bl = false;
            ArrayList arrayList = (ArrayList)this.inputsAtChannel[n].clone();
            for (BufferPointer bufferPointer : arrayList) {
                if (uGen.equals(bufferPointer.ugen) && bufferPointer.index == n2) {
                    this.removeInputAtChannel(n, bufferPointer);
                    bl = true;
                    continue;
                }
                ++n3;
            }
            if (n3 == 0) {
                this.noInputs = true;
                this.zeroIns();
            }
            return bl;
        }
        return false;
    }

    public synchronized void clearInputConnections() {
        for (int i = 0; i < this.inputsAtChannel.length; ++i) {
            ArrayList arrayList = (ArrayList)this.inputsAtChannel[i].clone();
            for (BufferPointer bufferPointer : arrayList) {
                this.removeInputAtChannel(i, bufferPointer);
            }
            this.noInputs = true;
            this.zeroIns();
        }
    }

    public void printInBuffers() {
        for (int i = 0; i < this.bufferSize; ++i) {
            System.out.print(this + " " + i + " ");
            for (int j = 0; j < this.ins; ++j) {
                System.out.print(this.bufIn[j][i] + " ");
            }
            System.out.println();
        }
    }

    public void printOutBuffers() {
        for (int i = 0; i < this.bufferSize; ++i) {
            System.out.print(this + " " + i + " ");
            for (int j = 0; j < this.outs; ++j) {
                System.out.print(this.bufOut[j][i] + " ");
            }
            System.out.println();
        }
    }

    public boolean noInputs() {
        return this.noInputs;
    }

    public abstract void calculateBuffer();

    public float getValue(int n, int n2) {
        return this.bufOut[n][n2];
    }

    public float[] getOutBuffer(int n) {
        return this.bufOut[n];
    }

    public float getValue() {
        return this.getValue(0, 0);
    }

    public double getValueDouble(int n, int n2) {
        return this.getValue(n, n2);
    }

    public double getValueDouble() {
        return this.getValue();
    }

    public void setValue(float f) {
    }

    public boolean isUpdated() {
        return this.lastTimeStep == this.context.getTimeStep();
    }

    @Override
    public void pause(boolean bl) {
        if (!this.isPaused() && bl) {
            this.setOutsToPause();
        }
        super.pause(bl);
    }

    public boolean isTimerMode() {
        return this.timerMode;
    }

    public void setTimerMode(boolean bl) {
        this.timerMode = bl;
    }

    public long getTimeTakenLastUpdate() {
        return this.timeTakenLastUpdate;
    }

    private class BufferPointer {
        final UGen ugen;
        final int index;

        BufferPointer(UGen uGen2, int n) {
            this.ugen = uGen2;
            this.index = n;
        }

        float[] getBuffer() {
            return this.ugen.bufOut[this.index];
        }

        float get(int n) {
            return this.ugen.getValue(this.index, n);
        }
    }

    protected static enum OutputPauseRegime {
        ZERO,
        RETAIN,
        NULL;

    }

    protected static enum OutputInitializationRegime {
        ZERO,
        NULL,
        JUNK,
        RETAIN;

    }
}

