/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBeadReceiver;

public class DataBead
extends Bead
implements Map<String, Object> {
    public Map<String, Object> properties;

    public DataBead() {
        this.properties = new Hashtable<String, Object>();
    }

    public DataBead(String string, Object object) {
        this.properties = new Hashtable<String, Object>();
        if (string != null) {
            this.properties.put(string, object);
        }
    }

    public DataBead(String[] stringArray, Object[] objectArray) {
        this.properties = new Hashtable<String, Object>();
        if (stringArray != null && objectArray != null) {
            int n = Math.min(stringArray.length, objectArray.length);
            for (int i = 0; i < n; ++i) {
                if (stringArray[i] == null) continue;
                this.properties.put(stringArray[i], objectArray[i]);
            }
        }
    }

    public DataBead(Map<String, Object> map) {
        this.properties = map == null ? new Hashtable<String, Object>() : map;
    }

    public DataBead(Object ... objectArray) {
        this.properties = new Hashtable<String, Object>();
        this.putAll(objectArray);
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.putAll((Map<? extends String, ? extends Object>)((DataBead)bead).properties);
        }
    }

    public void putAll(DataBead dataBead) {
        this.putAll((Map<? extends String, ? extends Object>)dataBead.properties);
    }

    public void putAll(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; i += 2) {
            this.put((String)objectArray[i], objectArray[i + 1]);
        }
    }

    public void configureObject(Object object) {
        if (object instanceof DataBeadReceiver) {
            ((DataBeadReceiver)object).sendData(this);
        } else {
            for (String string : this.properties.keySet()) {
                String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
                Object object2 = this.properties.get(string);
                try {
                    Method method = object.getClass().getMethod(string2, object2.getClass());
                    method.invoke(object, object2);
                }
                catch (Exception exception) {}
            }
        }
    }

    public float getFloat(String string, float f) {
        Float f2 = this.getFloatObject(string);
        if (f2 == null) {
            return f;
        }
        return f2.floatValue();
    }

    public Float getFloatObject(String string) {
        Object object = this.get(string);
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof String) {
            try {
                Float f = Float.valueOf(Float.parseFloat((String)object));
                return f;
            }
            catch (Exception exception) {}
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf(0.0f);
        }
        return null;
    }

    public UGen getUGen(String string) {
        Object object = this.get(string);
        if (object instanceof UGen) {
            return (UGen)object;
        }
        return null;
    }

    public float[] getFloatArray(String string) {
        Object object;
        Object object2 = this.get(string);
        if (object2 instanceof Number[]) {
            Number[] numberArray = (Number[])object2;
            object = new float[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                object[i] = numberArray[i].floatValue();
            }
        } else if (object2 instanceof float[]) {
            object = (float[])object2;
        } else if (object2 instanceof double[]) {
            double[] dArray = (double[])object2;
            object = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                object[i] = (float)dArray[i];
            }
        } else if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            object = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                object[i] = nArray[i];
            }
        } else if (object2 instanceof long[]) {
            long[] lArray = (long[])object2;
            object = new float[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                object[i] = lArray[i];
            }
        } else if (object2 instanceof char[]) {
            char[] cArray = (char[])object2;
            object = new float[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                object[i] = cArray[i];
            }
        } else if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            object = new float[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                object[i] = byArray[i];
            }
        } else if (object2 instanceof short[]) {
            short[] sArray = (short[])object2;
            object = new float[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                object[i] = sArray[i];
            }
        } else if (object2 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object2;
            object = new float[blArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                object[i] = blArray[i] ? 1.0f : 0.0f;
            }
        } else {
            object = object2 instanceof Number ? new float[]{((Number)object2).floatValue()} : null;
        }
        return object;
    }

    public UGen[] getUGenArray(String string) {
        Object object = this.get(string);
        if (object instanceof UGen[]) {
            return (UGen[])object;
        }
        if (object instanceof UGen) {
            return new UGen[]{(UGen)object};
        }
        return null;
    }

    public DataBead clone() {
        DataBead dataBead = new DataBead();
        dataBead.setName(this.getName());
        dataBead.putAll((Map<? extends String, ? extends Object>)this.properties);
        return dataBead;
    }

    public static DataBead combine(DataBead dataBead, DataBead dataBead2) {
        DataBead dataBead3 = new DataBead();
        dataBead3.putAll(dataBead2);
        dataBead3.putAll(dataBead);
        return dataBead3;
    }

    @Override
    public String toString() {
        return super.toString() + ":\n" + this.properties.toString();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.properties.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.properties.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public Object get(Object object) {
        return this.properties.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Object put(String string, Object object) {
        return this.properties.put(string, object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.properties.putAll(map);
    }

    @Override
    public Object remove(Object object) {
        return this.properties.remove(object);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public void clear() {
        this.properties.clear();
    }
}

