/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.beadsproject.beads.data.Sample;

public class SampleManager {
    private static final Map<String, Sample> samples = new TreeMap<String, Sample>();
    private static final Map<String, ArrayList<Sample>> groups = new TreeMap<String, ArrayList<Sample>>();
    private static final Map<String, String> groupDirs = new TreeMap<String, String>();
    private static final Set<SampleGroupListener> listeners = new HashSet<SampleGroupListener>();
    private static boolean verbose = true;

    public static Sample sample(String string) {
        return SampleManager.sample(string, string);
    }

    public static void sample(String string, Sample sample) {
        if (samples.get(string) == null) {
            samples.put(string, sample);
            if (sample.getSimpleName() == null) {
                sample.setSimpleName(string);
            }
        }
    }

    public static Sample sample(String string, String string2) {
        Sample sample = samples.get(string);
        if (sample == null) {
            try {
                sample = new Sample(string2);
                samples.put(string, sample);
                if (verbose) {
                    System.out.println("Loaded " + string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sample;
    }

    public static List<Sample> group(String string, Sample[] sampleArray) {
        ArrayList<Object> arrayList;
        if (!groups.keySet().contains(string)) {
            arrayList = new ArrayList();
            groups.put(string, arrayList);
        } else {
            arrayList = groups.get(string);
        }
        for (int i = 0; i < sampleArray.length; ++i) {
            if (arrayList.contains(sampleArray[i])) continue;
            arrayList.add(sampleArray[i]);
        }
        for (SampleGroupListener sampleGroupListener : listeners) {
            sampleGroupListener.changed(string);
        }
        return arrayList;
    }

    public static List<Sample> group(String string, String string2) {
        return SampleManager.group(string, string2, Integer.MAX_VALUE);
    }

    public static List<Sample> group(String string, String string2, int n) {
        String[] stringArray;
        File file = null;
        try {
            stringArray = ClassLoader.getSystemResource(string2);
            if (stringArray != null) {
                file = new File(URLDecoder.decode(stringArray.getPath(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (file == null || !file.exists()) {
            file = new File(string2);
        }
        groupDirs.put(string, file.getAbsolutePath());
        stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = file.getAbsolutePath() + "/" + stringArray[i];
            if (!new File(string3).exists()) continue;
            stringArray[i] = string3;
        }
        return SampleManager.group(string, stringArray, n);
    }

    public static List<Sample> group(String string, String[] stringArray) {
        return SampleManager.group(string, stringArray, Integer.MAX_VALUE);
    }

    public static List<Sample> group(String string, String[] stringArray, int n) {
        ArrayList<Sample> arrayList;
        if (!groups.keySet().contains(string)) {
            arrayList = new ArrayList();
            groups.put(string, arrayList);
        } else {
            arrayList = groups.get(string);
        }
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String object = stringArray[i];
            try {
                Sample sample = SampleManager.sample(object, stringArray[i]);
                if (arrayList.contains(object) || sample == null) continue;
                if (n2++ >= n) break;
                arrayList.add(sample);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (SampleGroupListener sampleGroupListener : listeners) {
            sampleGroupListener.changed(string);
        }
        return arrayList;
    }

    public static void addToGroup(String string, Sample sample) {
        ArrayList<Object> arrayList;
        if (!groups.containsKey(string)) {
            arrayList = new ArrayList();
            groups.put(string, arrayList);
        } else {
            arrayList = groups.get(string);
        }
        if (!arrayList.contains(sample)) {
            arrayList.add(sample);
        }
        for (SampleGroupListener sampleGroupListener : listeners) {
            sampleGroupListener.changed(string);
        }
    }

    public static void addToGroup(String string, List<Sample> list) {
        ArrayList<Object> arrayList;
        if (list == null) {
            return;
        }
        if (!groups.containsKey(string)) {
            arrayList = new ArrayList();
            groups.put(string, arrayList);
        } else {
            arrayList = groups.get(string);
        }
        for (Sample object : list) {
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        for (SampleGroupListener sampleGroupListener : listeners) {
            sampleGroupListener.changed(string);
        }
    }

    public static Set<String> groups() {
        return groups.keySet();
    }

    public static List<String> groupsAsList() {
        return new ArrayList<String>(groups.keySet());
    }

    public static ArrayList<Sample> getGroup(String string) {
        return groups.get(string);
    }

    public static String getGroupDir(String string) {
        return groupDirs.get(string);
    }

    public static Sample randomFromGroup(String string) {
        ArrayList<Sample> arrayList = groups.get(string);
        return arrayList.get((int)(Math.random() * (double)arrayList.size()));
    }

    public static Sample fromGroup(String string, int n) {
        ArrayList<Sample> arrayList = groups.get(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList.get(n % arrayList.size());
    }

    public static void removeSample(String string) {
        if (samples.containsKey(string)) {
            samples.remove(string);
        }
    }

    public static void removeSample(Sample sample) {
        for (String string : samples.keySet()) {
            if (!samples.get(string).equals(sample)) continue;
            SampleManager.removeSample(string);
            break;
        }
    }

    public static void removeGroup(String string) {
        groups.remove(string);
        groupDirs.remove(string);
        for (SampleGroupListener sampleGroupListener : listeners) {
            sampleGroupListener.changed(string);
        }
    }

    public static void destroyGroup(String string) {
        ArrayList<Sample> arrayList = groups.get(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            SampleManager.removeSample(arrayList.get(i));
        }
        SampleManager.removeGroup(string);
    }

    public static void addGroupListener(SampleGroupListener sampleGroupListener) {
        listeners.add(sampleGroupListener);
    }

    public static void removeGroupListener(SampleGroupListener sampleGroupListener) {
        listeners.remove(sampleGroupListener);
    }

    public static void printSampleList() {
        for (String string : samples.keySet()) {
            System.out.println(string + " " + samples.get(string));
        }
    }

    public static List<String> getSampleNameList() {
        return new ArrayList<String>(samples.keySet());
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void logSamplePaths(String string) {
        try {
            File file = new File(string);
            PrintWriter printWriter = new PrintWriter(file);
            for (Sample sample : samples.values()) {
                if (sample.getFileName() == null || sample.getFileName().equals("")) continue;
                printWriter.println("\"" + sample.getFileName() + "\"");
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static void transferSamples(String string, String string2, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        string = file.getAbsolutePath();
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        string2 = file2.getAbsolutePath();
        for (Sample sample : samples.values()) {
            String string3;
            if (sample.getFileName() == null || sample.getFileName().equals("") || !(string3 = sample.getFileName()).startsWith(string)) continue;
            String string4 = string3.replace(string, string2);
            if (!bl && new File(string4).exists()) continue;
            try {
                File file3 = new File(string4).getParentFile();
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                sample.write(string4);
                System.out.println("Copied file \"" + string3 + "\" to \"" + string4 + "\"");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static interface SampleGroupListener {
        public void changed(String var1);
    }
}

