/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.beadsproject.beads.analysis.Analyzer;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.featureextractors.MelSpectrum;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.gui.FloatArrayPlot;
import net.beadsproject.beads.gui.LevelMeter;
import net.beadsproject.beads.gui.OnsetView;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Throughput;

public class AudioInputGUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    AudioContext ac;
    Analyzer anal;
    UGen analysisMix;

    public AudioInputGUI(AudioContext ac) {
        this(ac, new ArrayList());
    }

    public AudioInputGUI(AudioContext ac, List<Class<? extends FeatureExtractor<?, ?>>> extractors) {
        this.ac = ac;
        if (!extractors.contains(MelSpectrum.class)) {
            extractors.add(MelSpectrum.class);
        }
        this.anal = new Analyzer(ac, extractors);
        this.anal.setFrameMemory(1);
        this.analysisMix = new Throughput(ac, 1);
        Throughput monitorMix = new Throughput(ac, 1);
        this.anal.listenTo(this.analysisMix);
        this.anal.updateFrom(this.analysisMix);
        ac.out.addDependent(this.analysisMix);
        this.setLayout(new BoxLayout(this, 0));
        UGen input = ac.getAudioInput();
        System.out.println("Number of inputs: " + input.getOuts());
        this.add(Box.createHorizontalStrut(10));
        Slider[] analysisGains = new Slider[input.getOuts()];
        int i = 0;
        while (i < analysisGains.length) {
            analysisGains[i] = new Slider(ac, "Analysis " + i, 0.0f, 2.0f, i == 0 ? 1 : 0);
            Gain g = new Gain(ac, 1, analysisGains[i]);
            g.addInput(0, input, i);
            LevelMeter meter = new LevelMeter(g);
            this.analysisMix.addInput(g);
            this.add(analysisGains[i].getComponent());
            this.add(meter.getComponent());
            ++i;
        }
        this.add(Box.createHorizontalStrut(10));
        Slider[] monitorGains = new Slider[input.getOuts()];
        int i2 = 0;
        while (i2 < monitorGains.length) {
            monitorGains[i2] = new Slider(ac, "Monitor " + i2, 0.0f, 2.0f, 0.0f);
            Gain g = new Gain(ac, 1, monitorGains[i2]);
            g.addInput(0, input, i2);
            LevelMeter meter = new LevelMeter(g);
            monitorMix.addInput(g);
            this.add(monitorGains[i2].getComponent());
            this.add(meter.getComponent());
            ++i2;
        }
        this.add(Box.createHorizontalStrut(10));
        FloatArrayPlot fap = new FloatArrayPlot((FeatureExtractor)this.anal.getElement(MelSpectrum.class), 0.0f, 100.0f);
        fap.setViewMode(FloatArrayPlot.ViewMode.INSTANT);
        this.anal.addSegmentListener(fap);
        this.add(fap.getComponent());
        this.add(Box.createHorizontalStrut(10));
        OnsetView ov = new OnsetView(ac);
        ac.out.addDependent(ov);
        this.anal.addBeatListener(ov);
        this.add(ov.getComponent());
        this.add(Box.createHorizontalStrut(10));
        Slider gainSlider = new Slider(ac, "Master Gain", 0.0f, 2.0f, 1.0f);
        ac.out.setGain(gainSlider);
        this.add(gainSlider.getComponent());
        LevelMeter meter = new LevelMeter(ac.out);
        this.add(meter.getComponent());
        this.add(Box.createHorizontalStrut(10));
        ac.out.addInput(monitorMix);
    }

    public UGen getAnalysisMix() {
        return this.analysisMix;
    }

    public static AudioInputGUI createAndShow(AudioContext ac, List<Class<? extends FeatureExtractor<?, ?>>> extractors) {
        AudioInputGUI newGui = new AudioInputGUI(ac, extractors);
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(Box.createVerticalStrut(10));
        p.add(newGui);
        p.add(Box.createVerticalStrut(10));
        f.setContentPane(p);
        f.pack();
        f.setResizable(false);
        f.setVisible(true);
        return newGui;
    }

    public Analyzer getAnalyzer() {
        return this.anal;
    }
}

