/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.gui.BeadsKeys;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.gui.BeadsWindow;
import net.beadsproject.beads.gui.EnvironmentPanel;
import net.beadsproject.beads.gui.Readout;
import net.beadsproject.beads.gui.SampleManagerPanel;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.gui.Slider2D;
import net.beadsproject.beads.gui.SongGrid;
import net.beadsproject.beads.gui.TimeGraph;
import net.beadsproject.beads.play.Environment;
import net.beadsproject.beads.play.GroupPlayer;
import net.beadsproject.beads.play.SongGroup;
import net.beadsproject.beads.play.SongPart;
import net.beadsproject.beads.ugens.Clock;

public class BeadsGui {
    private SongGrid songGrid;
    private BeadsWindow environmentFrame;
    private float temporaryTempo;
    private double timeAtLastTap;
    private Slider tempoSlider;
    private Clock clock;
    private Slider2D generic2DControl;

    public BeadsGui(AudioContext ac) {
        Environment env = null;
        try {
            env = Environment.loadEnvironment("net.beadsproject.beads.play.DefaultEnvironmentFactory", ac);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.setup(env);
        this.timeAtLastTap = 0.0;
    }

    public BeadsGui(Environment env) {
        this.setup(env);
    }

    private void setup(final Environment env) {
        this.environmentFrame = new BeadsWindow("Beads");
        JButton audioButton = new JButton("Start"){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                if (env.ac.isRunning()) {
                    this.setText("Stop");
                } else {
                    this.setText("Start");
                }
                super.paintComponent(g);
            }
        };
        audioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (env.ac.isRunning()) {
                    env.ac.stop();
                } else {
                    env.ac.start();
                }
            }
        });
        audioButton.setFocusable(false);
        this.environmentFrame.content.add(audioButton);
        EnvironmentPanel environmentPanel = new EnvironmentPanel(env);
        this.environmentFrame.content.add(environmentPanel);
        GroupPlayer p = new GroupPlayer(env);
        this.songGrid = new SongGrid(p, environmentPanel);
        this.songGrid.titledBorder("Song Parts");
        this.environmentFrame.content.add(this.songGrid);
        this.clock = (Clock)env.elements.get("master clock");
        this.tempoSlider = new Slider(env.ac, "tempo", -200.0f, 1000.0f, 175.0f);
        this.tempoSlider.storeValue(175.0f);
        this.tempoSlider.storeValue(87.5f);
        this.tempoSlider.storeValue(116.66666f);
        this.tempoSlider.storeValue(-175.0f);
        env.elements.put("bpm", this.tempoSlider);
        UGen tempoToInterval = new UGen(this.clock.getContext(), 1, 1){

            @Override
            public void calculateBuffer() {
                int i = 0;
                while (i < this.bufferSize) {
                    this.bufOut[0][i] = 60000.0f / this.bufIn[0][i];
                    ++i;
                }
            }
        };
        tempoToInterval.addInput(this.tempoSlider);
        this.clock.setIntervalEnvelope(tempoToInterval);
        env.ac.out.addDependent(this.tempoSlider);
        BeadsPanel ci = new BeadsPanel();
        ci.add(this.tempoSlider.getComponent());
        Slider slider2 = new Slider(env.ac, "gain", 0.0f, 2.0f, 1.0f);
        env.ac.out.setGain(slider2);
        ci.add(slider2.getComponent());
        ci.titledBorder("Master Controls");
        TimeGraph tg = new TimeGraph(4);
        this.clock.addMessageListener(tg);
        tg.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BeadsGui.this.tempoSlider.getValue() == 0.0f) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else {
                    BeadsGui.this.temporaryTempo = BeadsGui.this.tempoSlider.getCurrentValue();
                    BeadsGui.this.tempoSlider.setValue(0.0f);
                }
            }
        });
        BeadsKeys.addListener(new BeadsKeys.KeyboardListener(){

            @Override
            public void keyPressed(int keyCode) {
                if (keyCode == 32) {
                    if (BeadsGui.this.tempoSlider.getValue() == 0.0f) {
                        BeadsGui.this.clock.reset();
                        BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                    } else {
                        BeadsGui.this.temporaryTempo = BeadsGui.this.tempoSlider.getCurrentValue();
                        BeadsGui.this.tempoSlider.setValue(0.0f);
                    }
                } else if (keyCode == 90) {
                    BeadsGui.this.tap();
                } else if (keyCode == 49) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = -100.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 50) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = -10.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 51) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 20.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 52) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 87.5f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 53) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 131.25f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 54) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 175.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 55) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 350.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 56) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 525.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 57) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 700.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                } else if (keyCode == 48) {
                    BeadsGui.this.clock.reset();
                    BeadsGui.this.temporaryTempo = 1000.0f;
                    BeadsGui.this.tempoSlider.setValue(BeadsGui.this.temporaryTempo);
                }
            }

            @Override
            public void keyReleased(int keyCode) {
            }
        });
        ci.add(tg.getComponent());
        final Readout r = new Readout("time", "");
        this.clock.addMessageListener(new Bead(){

            @Override
            public void messageReceived(Bead message) {
                r.setText(String.valueOf(BeadsGui.this.clock.getBeatCount()) + " " + BeadsGui.this.clock.getCount());
            }
        });
        ci.add(r.getComponent());
        SampleManagerPanel smp = new SampleManagerPanel(100);
        if (env.elements.containsKey("audioDir")) {
            smp.setRootDir((String)env.elements.get("audioDir"));
        }
        ci.add(smp.getComponent());
        this.environmentFrame.content.add(ci);
        this.environmentFrame.setResizable(true);
        this.environmentFrame.setVisible(true);
        this.environmentFrame.pack();
        Graphics2D graphics = (Graphics2D)this.environmentFrame.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void repack() {
        ((JFrame)this.songGrid.getTopLevelAncestor()).pack();
    }

    public Clock getClock() {
        return this.clock;
    }

    public void tap() {
        double currentTime = this.tempoSlider.getContext().getTime();
        double interval = currentTime - this.timeAtLastTap;
        this.tempoSlider.setValue((float)(60000.0 / interval));
        this.timeAtLastTap = currentTime;
    }

    public void addSongGroup(SongGroup sg) {
        this.songGrid.addSongGroup(sg);
        this.environmentFrame.pack();
    }

    public void addSongGroup() {
        this.songGrid.addSongGroup();
        this.environmentFrame.pack();
    }

    public void addSongGroups(int numGroups) {
        this.songGrid.addSongGroups(numGroups);
        this.environmentFrame.pack();
    }

    public void setCurrentGroup(int i) {
        this.songGrid.setCurrentGroup(i);
    }

    public void addSongPart(SongPart sp) {
        this.songGrid.addSongPart(sp);
        this.environmentFrame.pack();
    }
}

