/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import net.beadsproject.beads.gui.BeadsWindow;

public class BeadsKeys
implements KeyListener {
    private static final ArrayList<KeyboardListener> listeners = new ArrayList();
    public static final boolean[] keysDown = new boolean[500];
    public static final BeadsKeys singleton = new BeadsKeys();

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        BeadsKeys.keysDown[keyCode] = true;
        for (KeyboardListener listener : listeners) {
            listener.keyPressed(keyCode);
        }
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        BeadsKeys.keysDown[keyCode] = false;
        for (KeyboardListener listener : listeners) {
            listener.keyReleased(keyCode);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static synchronized void addListener(KeyboardListener listener) {
        listeners.add(listener);
    }

    public static synchronized void removeListener(KeyboardListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void clearListeners() {
        listeners.clear();
    }

    public static boolean keyDown(int keyCode) {
        return keysDown[keyCode];
    }

    public static void printKeysDown() {
        int i = 0;
        while (i < keysDown.length) {
            if (keysDown[i]) {
                System.out.println(i);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        BeadsWindow bw = new BeadsWindow("hello world");
        bw.setVisible(true);
    }

    public static interface KeyboardListener {
        public void keyPressed(int var1);

        public void keyReleased(int var1);
    }
}

