/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.BeadsDialog;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.play.InterfaceElement;
import net.beadsproject.beads.play.Music;

public class Chooser
implements InterfaceElement {
    protected List<String> elements;
    private int boxHeight;
    private int boxWidth;
    private int charachterWidth;
    private int popupBoxWidth;
    protected int choice;
    private int tempChoice;
    private int textVOffset;
    private ChooserListener listener;
    private JComponent component;
    private String label;

    public Chooser(String label) {
        this.setLabel(label);
        this.elements = new ArrayList<String>();
        this.choice = 0;
        this.boxWidth = 100;
        this.charachterWidth = 5;
        this.popupBoxWidth = 200;
        this.boxHeight = 10;
        this.textVOffset = 1;
    }

    @Override
    public JComponent getComponent() {
        this.refreshList();
        final JComponent valueComponent = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.black);
                g.drawString(Chooser.this.getChoice(), 0, Chooser.this.boxHeight - Chooser.this.textVOffset);
            }
        };
        valueComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Chooser.this.refreshList();
                final BeadsDialog popup = new BeadsDialog((Frame)Chooser.this.component.getTopLevelAncestor());
                popup.setUndecorated(true);
                Chooser.this.tempChoice = Chooser.this.choice;
                final BeadsPanel list = new BeadsPanel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void paintComponent(Graphics g) {
                        Graphics2D g2d = (Graphics2D)g;
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setColor(Color.white);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g.setColor(Color.black);
                        int height = 0;
                        for (String s : (this).Chooser.this.elements) {
                            if (Chooser.this.tempChoice == height) {
                                g.setColor(Color.gray);
                                g.fillRect(0, height * Chooser.this.boxHeight, Chooser.this.popupBoxWidth, Chooser.this.boxHeight);
                                g.setColor(Color.black);
                            }
                            g.drawString(s, 0, (height++ + 1) * Chooser.this.boxHeight - Chooser.this.textVOffset);
                        }
                    }
                };
                popup.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        popup.dispose();
                    }
                });
                list.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        popup.dispose();
                        (this).Chooser.this.choice = Chooser.this.tempChoice;
                        Chooser.this.component.repaint();
                        if (Chooser.this.listener != null) {
                            Chooser.this.listener.choice((this).Chooser.this.elements.get((this).Chooser.this.choice));
                        }
                    }
                });
                list.addMouseMotionListener(new MouseMotionListener(){

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        Chooser.this.tempChoice = e.getY() / Chooser.this.boxHeight;
                        list.repaint();
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        this.mouseDragged(e);
                    }
                });
                Dimension d = new Dimension(Chooser.this.popupBoxWidth, Chooser.this.boxHeight * Chooser.this.elements.size());
                list.setFont(new Font("Courier", 0, 10));
                list.setMinimumSize(d);
                list.setPreferredSize(d);
                list.setMaximumSize(d);
                popup.setContentPane(list);
                popup.pack();
                popup.setLocation((int)valueComponent.getLocationOnScreen().getX(), (int)valueComponent.getLocationOnScreen().getY() - Chooser.this.choice * Chooser.this.boxHeight);
                popup.setVisible(true);
            }
        });
        Dimension size = new Dimension(this.boxWidth, this.boxHeight);
        valueComponent.setFont(new Font("Courier", 0, 10));
        valueComponent.setPreferredSize(size);
        valueComponent.setMinimumSize(size);
        valueComponent.setMaximumSize(size);
        BeadsPanel container = new BeadsPanel();
        container.horizontalBox();
        String tempLabel = this.label;
        while (tempLabel.length() < 7) {
            tempLabel = String.valueOf(tempLabel) + " ";
        }
        JLabel nameLabel = new JLabel(tempLabel);
        nameLabel.setFont(new Font("Courier", 0, 10));
        container.add(nameLabel);
        container.add(valueComponent);
        this.component = container;
        return this.component;
    }

    public void refreshList() {
    }

    public void add(String s) {
        this.elements.add(s);
        int textWidth = s.length() * this.charachterWidth;
        if (textWidth > this.popupBoxWidth) {
            this.popupBoxWidth = textWidth;
        }
        this.popupBoxWidth = Math.max(200, this.popupBoxWidth);
    }

    public int getBoxHeight() {
        return this.boxHeight;
    }

    public void setBoxHeight(int boxHeight) {
        this.boxHeight = boxHeight;
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    public ChooserListener getListener() {
        return this.listener;
    }

    public void setListener(ChooserListener listener) {
        this.listener = listener;
    }

    private void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setChoice(int c) {
        this.choice = c;
        if (this.choice >= this.elements.size()) {
            this.choice = this.elements.size() - 1;
        }
        if (this.listener != null && this.choice != -1) {
            this.listener.choice(this.elements.get(this.choice));
        }
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public void setChoice(String choice) {
        if (this.elements.contains(choice)) {
            int i = 0;
            while (i < this.elements.size()) {
                if (this.elements.get(i).equals(choice)) break;
                ++i;
            }
            this.setChoice(i);
        }
    }

    public String getChoice() {
        if (this.elements == null || this.elements.size() == 0) {
            return "";
        }
        if (this.choice >= this.elements.size()) {
            this.choice = this.elements.size() - 1;
        }
        return this.elements.get(this.choice);
    }

    public int getChoiceIndex() {
        return this.choice;
    }

    public void clear() {
        this.elements.clear();
    }

    public void repaint() {
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public static Chooser sampleGroupChooser() {
        final Chooser c = new Chooser("group"){

            @Override
            public void refreshList() {
                String currentChoice = this.getChoice();
                this.clear();
                int count = 0;
                for (String s : SampleManager.groups()) {
                    this.add(s);
                    if (s == currentChoice) {
                        this.choice = count;
                    }
                    ++count;
                }
                this.repaint();
            }
        };
        SampleManager.addGroupListener(new SampleManager.SampleGroupListener(){

            @Override
            public void changed(String group) {
                c.refreshList();
            }
        });
        c.refreshList();
        c.setChoice(0);
        return c;
    }

    public static Chooser sampleChooserFromGroupChooser(final Chooser groupChooser) {
        final Chooser fileChooser = new Chooser("file"){

            @Override
            public void refreshList() {
                this.clear();
                String groupName = groupChooser.getChoice();
                ArrayList<Sample> samples = SampleManager.getGroup(groupName);
                for (Sample s : samples) {
                    String name = s.getSimpleName();
                    if (name == null) {
                        name = "Untitled";
                    }
                    this.add(name);
                }
                this.repaint();
            }
        };
        groupChooser.setListener(new ChooserListener(){

            @Override
            public void choice(String s) {
                fileChooser.refreshList();
                fileChooser.setChoice(fileChooser.choice);
            }
        });
        fileChooser.refreshList();
        fileChooser.setChoice(0);
        return fileChooser;
    }

    public static Chooser kitChooser() {
        Chooser kitChooser = new Chooser("kit"){

            @Override
            public void refreshList() {
                String currentChoice = this.getChoice();
                this.clear();
                int count = 0;
                for (String s : Music.kits.keySet()) {
                    this.add(s);
                    if (s == currentChoice) {
                        this.choice = count;
                    }
                    ++count;
                }
                this.repaint();
            }
        };
        kitChooser.refreshList();
        kitChooser.setChoice(0);
        return kitChooser;
    }

    public static Chooser patternChooser() {
        Chooser kitChooser = new Chooser("pattern"){

            @Override
            public void refreshList() {
                String currentChoice = this.getChoice();
                this.clear();
                int count = 0;
                for (String s : Music.patterns.keySet()) {
                    this.add(s);
                    if (s == currentChoice) {
                        this.choice = count;
                    }
                    ++count;
                }
                this.repaint();
            }
        };
        kitChooser.refreshList();
        kitChooser.setChoice(0);
        return kitChooser;
    }

    public static interface ChooserListener {
        public void choice(String var1);
    }
}

