/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.beadsproject.beads.core.BeadArray;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.gui.BeadsList;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.play.Environment;
import net.beadsproject.beads.play.InterfaceElement;
import net.beadsproject.beads.play.SongPart;
import net.beadsproject.beads.ugens.Clock;

public class EnvironmentPanel
extends BeadsPanel {
    private final BeadsList channelsList;
    private final BeadsList pathwaysList;
    protected final BeadsPanel elementsPanel;
    protected final Environment e;

    public EnvironmentPanel(Environment e) {
        this.e = e;
        this.horizontalBox();
        this.channelsList = new BeadsList();
        this.pathwaysList = new BeadsList();
        this.setupList(this.channelsList, "Channels");
        this.setupList(this.pathwaysList, "Pathways");
        this.elementsPanel = new BeadsPanel();
        this.elementsPanel.horizontalBox();
        this.elementsPanel.emptyBorder();
        this.elementsPanel.fixSize(100, 200);
        this.rebuild();
    }

    public void setupList(BeadsList list, String name) {
        BeadsPanel panel = new BeadsPanel();
        panel.fixSize(100, 200);
        panel.verticalBox();
        panel.titledBorder(name);
        panel.add(new JScrollPane(list));
        this.add(panel);
    }

    public void rebuild() {
        this.reloadList(this.channelsList, this.e.channels.keySet(), "out");
        this.reloadList(this.pathwaysList, this.e.pathways.keySet(), "master clock");
        this.reloadElementsPanel();
    }

    public void reloadList(BeadsList list, Set<String> set, String selectedValue) {
        for (String s : set) {
            list.addElement(s);
        }
        list.setSelectedValue(selectedValue, true);
    }

    public void reloadElementsPanel() {
        for (Object o : this.e.elements.values()) {
            if (!(o instanceof InterfaceElement)) continue;
            this.elementsPanel.add(((InterfaceElement)o).getComponent());
        }
    }

    public UGen getSelectedChannel() {
        return this.e.channels.get((String)this.channelsList.getLastSelected());
    }

    public BeadArray getSelectedPathway() {
        return this.e.pathways.get((String)this.pathwaysList.getLastSelected());
    }

    public Clock getSelectedClock() {
        return (Clock)this.e.elements.get("master clock");
    }

    public JPopupMenu getChannelsPathwaysPopupMenu(final SongPart sp) {
        JPopupMenu mainMenu = new JPopupMenu();
        JMenu channelsMenu = new JMenu("Channel");
        for (String channel : this.e.channels.keySet()) {
            final JCheckBoxMenuItem newItem = new JCheckBoxMenuItem(channel);
            if (this.e.channels.get(channel).containsInput(sp)) {
                newItem.setSelected(true);
            }
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evnt) {
                    for (String channel : EnvironmentPanel.this.e.channels.keySet()) {
                        EnvironmentPanel.this.e.channels.get(channel).removeAllConnections(sp);
                    }
                    EnvironmentPanel.this.e.channels.get(newItem.getText()).addInput(sp);
                }
            });
            channelsMenu.add(newItem);
        }
        mainMenu.add(channelsMenu);
        JMenu pathsMenu = new JMenu("Path");
        for (String path : this.e.pathways.keySet()) {
            JMenuItem newItem = new JMenuItem(path);
            pathsMenu.add(newItem);
        }
        mainMenu.add(pathsMenu);
        return mainMenu;
    }
}

