/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.play.InterfaceElement;

public class FloatArrayPlot
implements InterfaceElement,
SegmentListener {
    JComponent component;
    ViewMode viewMode;
    float[] instantData;
    float[][] historyData;
    int historyLength;
    int historyIndex;
    float min;
    float max;
    float range;
    boolean adaptiveRange;
    FeatureExtractor<float[], ?> extractor;

    public FloatArrayPlot(FeatureExtractor<float[], ?> extractor, float min, float max) {
        this(min, max);
        this.listenTo(extractor);
    }

    public FloatArrayPlot(FeatureExtractor<float[], ?> extractor, boolean adaptive) {
        this(adaptive);
        this.listenTo(extractor);
    }

    public FloatArrayPlot(float min, float max) {
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.adaptiveRange = false;
        this.viewMode = ViewMode.INSTANT;
    }

    public FloatArrayPlot(boolean adaptive) {
        this.min = 0.0f;
        this.max = 0.0f;
        this.range = 0.0f;
        this.adaptiveRange = adaptive;
        this.viewMode = ViewMode.INSTANT;
    }

    public void setViewMode(ViewMode vm) {
        this.viewMode = vm;
        if (this.viewMode == ViewMode.INSTANT) {
            this.historyData = null;
        } else {
            this.historyLength = 4000;
            this.historyData = new float[this.historyLength][this.extractor.getNumberOfFeatures()];
            this.historyIndex = 0;
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new BeadsComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (FloatArrayPlot.this.viewMode == ViewMode.INSTANT) {
                        if (FloatArrayPlot.this.instantData != null && FloatArrayPlot.this.range != 0.0f) {
                            float blockWidth = (float)this.getWidth() / (float)FloatArrayPlot.this.instantData.length;
                            g.setColor(Color.lightGray);
                            int i = 0;
                            while (i < FloatArrayPlot.this.instantData.length) {
                                int height = (int)((FloatArrayPlot.this.instantData[i] - FloatArrayPlot.this.min) / FloatArrayPlot.this.range * (float)this.getHeight());
                                g.fillRect((int)((float)i * blockWidth), this.getHeight() - 1 - height, Math.max(3, (int)blockWidth), height);
                                ++i;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < this.getWidth()) {
                            int index = (int)((float)i / (float)this.getWidth() * (float)FloatArrayPlot.this.historyLength);
                            index = (FloatArrayPlot.this.historyIndex + index) % FloatArrayPlot.this.historyLength;
                            int j = 0;
                            while (j < FloatArrayPlot.this.extractor.getNumberOfFeatures()) {
                                int y = this.getHeight() - j * this.getHeight() / FloatArrayPlot.this.extractor.getNumberOfFeatures();
                                float darkness = 1.0f - Math.max(0.0f, Math.min(1.0f, (FloatArrayPlot.this.historyData[index][j] - FloatArrayPlot.this.min) / FloatArrayPlot.this.range));
                                g.setColor(new Color(darkness, darkness, darkness));
                                g.fillRect(i, y, 1, 1);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            };
        }
        Dimension size = new Dimension(200, 100);
        this.component.setMinimumSize(size);
        this.component.setPreferredSize(size);
        this.component.setMaximumSize(size);
        return this.component;
    }

    public void listenTo(FeatureExtractor<float[], ?> extractor) {
        this.extractor = extractor;
    }

    @Override
    public void newSegment(TimeStamp start, TimeStamp end) {
        float[] f;
        if (this.component != null && this.extractor != null && (f = this.extractor.getFeatures()) != null) {
            if (this.viewMode == ViewMode.INSTANT) {
                this.instantData = f;
            } else {
                this.historyData[this.historyIndex] = (float[])f.clone();
                this.historyIndex = (this.historyIndex + 1) % this.historyLength;
            }
            if (this.adaptiveRange) {
                int i = 0;
                while (i < f.length) {
                    if (this.min > this.instantData[i]) {
                        this.min = f[i];
                    }
                    if (this.max < this.instantData[i]) {
                        this.max = f[i];
                    }
                    ++i;
                }
                this.range = this.max - this.min;
            }
            this.component.repaint();
        }
    }

    public static enum ViewMode {
        INSTANT,
        HISTORY;

    }
}

