/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Random;
import javax.swing.JComponent;
import net.beadsproject.beads.play.InterfaceElement;

public class Histogram
implements InterfaceElement {
    private String name;
    private int boxWidth;
    private int boxHeight;
    private float[] sliders;
    private HistogramListener listener;
    private JComponent component;

    public Histogram(String name, int numSliders) {
        this.name = name;
        this.sliders = new float[numSliders];
        this.boxWidth = 10;
        this.boxHeight = 100;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    int i = 0;
                    while (i < Histogram.this.sliders.length) {
                        g.fillRect(i * Histogram.this.boxWidth, (int)((1.0f - Histogram.this.sliders[i]) * (float)this.getHeight()), Histogram.this.boxWidth, this.getHeight());
                        ++i;
                    }
                    g.setColor(Color.gray);
                    i = 0;
                    while (i < Histogram.this.sliders.length) {
                        g.drawRect(i * Histogram.this.boxWidth, 0, Histogram.this.boxWidth, this.getHeight());
                        ++i;
                    }
                    g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                    g.drawString(Histogram.this.name, 2, 12);
                }
            };
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int i = e.getX() / Histogram.this.boxWidth;
                    float j = 1.0f - (float)e.getY() / (float)Histogram.this.boxHeight;
                    if (i >= 0 && i < Histogram.this.sliders.length && j >= 0.0f && j < 1.0f) {
                        Histogram.this.makeSelection(i, j);
                        Histogram.this.component.repaint();
                    }
                }
            });
            this.component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int i = e.getX() / Histogram.this.boxWidth;
                    float j = 1.0f - (float)e.getY() / (float)Histogram.this.boxHeight;
                    if (i >= 0 && i < Histogram.this.sliders.length && j >= 0.0f && j < 1.0f) {
                        Histogram.this.makeSelection(i, j);
                        Histogram.this.component.repaint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            Dimension size = new Dimension(this.sliders.length * this.boxWidth + 1, 100);
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }

    private void makeSelection(int index, float value) {
        this.setValue(index, value);
        if (this.listener != null) {
            this.listener.valueChanged(index, value);
        }
    }

    public void setValue(int index, float value) {
        if (index < this.sliders.length) {
            this.sliders[index] = value;
        }
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public float getValue(int index) {
        return this.sliders[index];
    }

    public void setListener(HistogramListener listener) {
        this.listener = listener;
    }

    public float nextIndexByProb(Random rng) {
        float sum = 0.0f;
        int i = 0;
        i = 0;
        while (i < this.sliders.length) {
            sum += this.sliders[i];
            ++i;
        }
        float result = rng.nextFloat() * sum;
        sum = 0.0f;
        i = 0;
        while (i < this.sliders.length) {
            if (result < (sum += this.sliders[i])) break;
            ++i;
        }
        return i;
    }

    public static interface HistogramListener {
        public void valueChanged(int var1, float var2);
    }
}

