/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.gui.ButtonBox;
import net.beadsproject.beads.gui.Chooser;
import net.beadsproject.beads.gui.SingleButton;
import net.beadsproject.beads.play.Pattern;
import net.beadsproject.beads.play.PatternPlayer;

public class PatternGrid
extends ButtonBox {
    private Pattern pattern = new Pattern();
    private PatternPlayer patternPlayer = new PatternPlayer(this.pattern);
    private JComponent component;
    private int numNotesVisible = 20;
    private Chooser loopChooser;

    public PatternGrid(int width, int height) {
        super(width, height, ButtonBox.SelectionMode.MULTIPLE_SELECTION);
        this.patternPlayer.setLoop(width);
        this.patternPlayer.setContinuousPlayMode(PatternPlayer.ContinuousPlayMode.INTERNAL);
        this.setListener(new ButtonBox.ButtonBoxListener(){

            @Override
            public void buttonOff(int i, int j) {
                PatternGrid.this.pattern.removeEvent(i, j);
            }

            @Override
            public void buttonOn(int i, int j) {
                PatternGrid.this.pattern.addEvent(i, j);
            }
        });
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
        this.patternPlayer.setPattern(pattern);
        if (this.loopChooser != null) {
            this.loopChooser.setChoice(this.patternPlayer.getLoop() - 1);
        }
        this.resize(this.patternPlayer.getLoop(), this.numNotesVisible);
        this.setBoxWidth(200.0f / (float)this.patternPlayer.getLoop());
        this.setBoxHeight(100.0f / (float)this.numNotesVisible);
        this.setBBFromPattern();
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public void setLoop(int loop) {
        this.patternPlayer.setLoop(loop);
        this.resize(loop, this.numNotesVisible);
        this.setBoxWidth(200.0f / (float)this.patternPlayer.getLoop());
        if (this.component != null) {
            this.component.repaint();
        }
        if (super.getComponent() != null) {
            super.getComponent().repaint();
        }
    }

    private void setBBFromPattern() {
        this.clear();
        for (Integer i : this.pattern.getEvents()) {
            ArrayList<Integer> sounds;
            if (i >= this.buttons.length || (sounds = this.pattern.getEventAtIndex(i)) == null) continue;
            for (Integer j : sounds) {
                if (j >= this.buttons[i].length) continue;
                this.buttons[i.intValue()][j.intValue()] = true;
            }
        }
    }

    public ArrayList<Integer> goToStep(int index) {
        ArrayList<Integer> event = this.patternPlayer.getEventAtStep(index);
        this.setColumnHighlight(this.patternPlayer.getLastIndex());
        return event;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            JComponent bb = super.getComponent();
            final BeadsPanel mainPanel = new BeadsPanel();
            mainPanel.add(bb);
            BeadsPanel buttonPanel = new BeadsPanel();
            buttonPanel.verticalBox();
            mainPanel.add(buttonPanel);
            SingleButton sb = new SingleButton("Read", SingleButton.Mode.ONESHOT);
            sb.setListener(new SingleButton.SingleButtonListener(){

                @Override
                public void buttonPressed(boolean newState) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog(mainPanel);
                    if (returnVal == 0) {
                        try {
                            PatternGrid.this.read(chooser.getSelectedFile().getAbsolutePath());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            buttonPanel.add(sb.getComponent());
            sb = new SingleButton("Write", SingleButton.Mode.ONESHOT);
            sb.setListener(new SingleButton.SingleButtonListener(){

                @Override
                public void buttonPressed(boolean newState) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showSaveDialog(mainPanel);
                    if (returnVal == 0) {
                        try {
                            PatternGrid.this.write(chooser.getSelectedFile().getAbsolutePath());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            buttonPanel.add(sb.getComponent());
            this.loopChooser = new Chooser("Loop");
            int i = 1;
            while (i < 33) {
                this.loopChooser.add("" + i);
                ++i;
            }
            this.loopChooser.setListener(new Chooser.ChooserListener(){

                @Override
                public void choice(String s) {
                    PatternGrid.this.setLoop(Integer.parseInt(s));
                }
            });
            this.loopChooser.setChoice(this.patternPlayer.getLoop() - 1);
            buttonPanel.add(this.loopChooser.getComponent());
            this.component = mainPanel;
        }
        return this.component;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public PatternPlayer getPatternPlayer() {
        return this.patternPlayer;
    }

    public void read(String filename) {
        URL url = AudioUtils.urlFromString(filename);
        if (url == null) {
            return;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(url.openStream());
            this.pattern = (Pattern)ois.readObject();
            this.patternPlayer.setPattern(this.pattern);
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBBFromPattern();
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public void write(String filename) {
        File f = new File(filename);
        this.pattern.setSuggestedLoop(this.patternPlayer.getLoop());
        try {
            FileOutputStream fos = new FileOutputStream(f);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.pattern);
            oos.close();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

