/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.play.InterfaceElement;

public class Slider2D
implements InterfaceElement {
    private final Slider sliderX;
    private final Slider sliderY;
    private JComponent component;
    State state;
    Path path;

    public Slider2D(Slider sliderX, Slider sliderY) {
        this.sliderX = sliderX;
        this.sliderY = sliderY;
        this.state = State.NORMAL;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new BeadsComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    g.setColor(Color.lightGray);
                    if (Slider2D.this.state != State.NORMAL) {
                        int i = 0;
                        while (i < Slider2D.this.path.xValues.size()) {
                            int xpos = (int)(Slider2D.this.sliderX.calculateFractFromValue(Slider2D.this.path.xValues.get(i).floatValue()) * (float)this.getWidth());
                            int ypos = (int)((1.0f - Slider2D.this.sliderY.calculateFractFromValue(Slider2D.this.path.yValues.get(i).floatValue())) * (float)this.getHeight());
                            g.fillOval(xpos - 3, ypos - 3, 6, 6);
                            ++i;
                        }
                    }
                    g.setColor(Color.gray);
                    g.drawString(Slider2D.this.sliderX.getName(), 2, 12);
                    g.drawString("" + Slider2D.this.sliderX.getValue(), 2, 26);
                    g.drawString(Slider2D.this.sliderY.getName(), 2, 40);
                    g.drawString("" + Slider2D.this.sliderY.getValue(), 2, 54);
                    g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
                    int xpos = (int)(Slider2D.this.sliderX.getValueFract() * (float)this.getWidth());
                    int ypos = (int)((1.0f - Slider2D.this.sliderY.getValueFract()) * (float)this.getHeight());
                    g.fillOval(xpos - 5, ypos - 5, 10, 10);
                }
            };
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    float xFract = (float)e.getX() / (float)Slider2D.this.component.getWidth();
                    float yFract = 1.0f - (float)e.getY() / (float)Slider2D.this.component.getHeight();
                    if ((e.getModifiers() & 8) != 0) {
                        if (Slider2D.this.state != State.RECORD) {
                            Slider2D.this.path = new Path(System.currentTimeMillis());
                            Slider2D.this.state = State.RECORD;
                        }
                    } else if (Slider2D.this.state == State.RECORD) {
                        Slider2D.this.state = State.PLAY;
                        Slider2D.this.path.play();
                    } else if (Slider2D.this.state == State.PLAY) {
                        Slider2D.this.state = State.NORMAL;
                    }
                    if (Slider2D.this.state != State.PLAY) {
                        Slider2D.this.sliderX.setValueFract(xFract);
                        Slider2D.this.sliderY.setValueFract(yFract);
                    }
                    if (Slider2D.this.state == State.RECORD) {
                        Slider2D.this.path.record(System.currentTimeMillis(), xFract, yFract);
                    }
                    Slider2D.this.component.repaint();
                }
            });
            this.component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    float xFract = (float)e.getX() / (float)Slider2D.this.component.getWidth();
                    float yFract = 1.0f - (float)e.getY() / (float)Slider2D.this.component.getHeight();
                    Slider2D.this.sliderX.setValueFract(xFract);
                    Slider2D.this.sliderY.setValueFract(yFract);
                    if (Slider2D.this.state == State.RECORD) {
                        Slider2D.this.path.record(System.currentTimeMillis(), xFract, yFract);
                    }
                    Slider2D.this.component.repaint();
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            this.component.setMinimumSize(new Dimension(100, 100));
            this.component.setPreferredSize(new Dimension(100, 100));
            this.component.setMaximumSize(new Dimension(100, 100));
        }
        return this.component;
    }

    public Slider getSliderX() {
        return this.sliderX;
    }

    public Slider getSliderY() {
        return this.sliderY;
    }

    private class Path {
        ArrayList<Float> xValues;
        ArrayList<Float> yValues;
        ArrayList<Float> times;
        double lastTime;

        Path(double time) {
            this.lastTime = time;
            this.xValues = new ArrayList();
            this.yValues = new ArrayList();
            this.times = new ArrayList();
        }

        public void record(double time, float xFract, float yFract) {
            float timeSinceLast = (float)(time - this.lastTime);
            this.lastTime = time;
            this.xValues.add(Float.valueOf(xFract));
            this.yValues.add(Float.valueOf(yFract));
            this.times.add(Float.valueOf(timeSinceLast));
        }

        public void play() {
            Slider2D.this.sliderX.clear();
            Slider2D.this.sliderY.clear();
            int i = 0;
            while (i < this.xValues.size()) {
                float destX = Slider2D.this.sliderX.calculateValueFromFract(this.xValues.get(i).floatValue());
                float destY = Slider2D.this.sliderY.calculateValueFromFract(this.yValues.get(i).floatValue());
                float time = this.times.get(i).floatValue();
                Slider2D.this.sliderX.addSegment(destX, time);
                Slider2D.this.sliderY.addSegment(destY, time, new Bead(){

                    @Override
                    public void messageReceived(Bead message) {
                        Slider2D.this.component.repaint();
                    }
                });
                if (i == this.xValues.size() - 1) {
                    Slider2D.this.sliderX.addSegment(destX, 0.0f, new Bead(){

                        @Override
                        public void messageReceived(Bead message) {
                            Path.this.play();
                        }
                    });
                }
                ++i;
            }
        }
    }

    private static enum State {
        NORMAL,
        RECORD,
        PLAY;

    }
}

