/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.beadsproject.beads.gui.BeadsKeys;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.gui.BeadsWindow;
import net.beadsproject.beads.gui.EnvironmentPanel;
import net.beadsproject.beads.gui.MicroPopup;
import net.beadsproject.beads.play.GroupPlayer;
import net.beadsproject.beads.play.SongGroup;
import net.beadsproject.beads.play.SongPart;

public class SongGrid
extends BeadsPanel {
    private static final long serialVersionUID = 1L;
    private JComponent grid;
    private JComponent groupPanel;
    private JComponent partPanel;
    private ArrayList<SongPart> parts;
    private ArrayList<SongGroup> groups;
    private Map<SongPart, BeadsWindow> partWindows;
    private int boxWidth = 15;
    private int partTextWidth = 150;
    private int groupTextHeight = 50;
    private GroupPlayer player;
    private EnvironmentPanel environmentPanel;

    public SongGrid(GroupPlayer p, EnvironmentPanel ep) {
        this.player = p;
        this.environmentPanel = ep;
        this.parts = new ArrayList();
        this.groups = new ArrayList();
        this.partWindows = new Hashtable<SongPart, BeadsWindow>();
        this.setLayout(new BoxLayout(this, 0));
        JPanel vPanel = new JPanel();
        vPanel.setLayout(new BoxLayout(vPanel, 1));
        this.partPanel = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                int i = 0;
                ArrayList partsCopy = (ArrayList)SongGrid.this.parts.clone();
                for (SongPart sp : partsCopy) {
                    Color c = sp.getColor();
                    if (c == null) {
                        c = Color.white;
                    }
                    g.setColor(c);
                    g.fillRect(2, SongGrid.this.groupTextHeight + i * SongGrid.this.boxWidth, 10, SongGrid.this.boxWidth);
                    if (SongGrid.this.player.getCurrentGroup() != null && SongGrid.this.player.getCurrentGroup().contains(sp)) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.gray);
                    }
                    g.drawString(sp.getName(), 14, SongGrid.this.groupTextHeight + (i + 1) * SongGrid.this.boxWidth - 4);
                    if (SongGrid.this.partWindows.containsKey(sp)) {
                        ((BeadsWindow)SongGrid.this.partWindows.get(sp)).setTitle(sp.getName());
                    }
                    ++i;
                }
            }
        };
        this.partPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block9: {
                    block7: {
                        SongPart sp;
                        block8: {
                            if (e.getY() <= SongGrid.this.groupTextHeight) break block7;
                            sp = (SongPart)SongGrid.this.parts.get((e.getY() - SongGrid.this.groupTextHeight) / SongGrid.this.boxWidth);
                            if (e.getClickCount() <= 1) break block8;
                            if (SongGrid.this.partWindows.containsKey(sp)) {
                                ((BeadsWindow)SongGrid.this.partWindows.get(sp)).setVisible(true);
                                ((BeadsWindow)SongGrid.this.partWindows.get(sp)).toFront();
                            } else {
                                BeadsWindow bw = new BeadsWindow(sp.getName());
                                bw.content.add(sp.getComponent());
                                bw.pack();
                                bw.setVisible(true);
                                bw.setResizable(false);
                                SongGrid.this.partWindows.put(sp, bw);
                            }
                            break block9;
                        }
                        if ((e.getModifiers() & 2) == 0) break block9;
                        JPopupMenu m = SongGrid.this.environmentPanel.getChannelsPathwaysPopupMenu(sp);
                        m.show(SongGrid.this.partPanel, e.getX(), e.getY());
                        break block9;
                    }
                    if ((e.getModifiers() & 2) != 0) {
                        JPopupMenu m = new JPopupMenu();
                        JMenuItem newGroupItem = new JMenuItem("new group");
                        newGroupItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SongGrid.this.addSongGroup();
                            }
                        });
                        m.add(newGroupItem);
                        m.show(SongGrid.this.partPanel, e.getX(), e.getY());
                    } else if (e.getClickCount() > 1) {
                        for (SongPart sp : SongGrid.this.partWindows.keySet()) {
                            if (SongGrid.this.partWindows.containsKey(sp)) {
                                ((BeadsWindow)SongGrid.this.partWindows.get(sp)).setVisible(SongGrid.this.player.getCurrentGroup().contains(sp));
                                ((BeadsWindow)SongGrid.this.partWindows.get(sp)).toFront();
                                continue;
                            }
                            BeadsWindow bw = new BeadsWindow(sp.getName());
                            bw.content.add(sp.getComponent());
                            bw.pack();
                            bw.setVisible(true);
                            bw.setResizable(false);
                            SongGrid.this.partWindows.put(sp, bw);
                        }
                    }
                }
            }
        });
        this.add(this.partPanel);
        this.groupPanel = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                int i = 1;
                ArrayList groupsCopy = (ArrayList)SongGrid.this.groups.clone();
                for (SongGroup sg : groupsCopy) {
                    g2d.rotate(-1.5707963267948966);
                    if (SongGrid.this.player.getCurrentGroup() == sg) {
                        g2d.setColor(Color.gray);
                        g2d.fillRect(-SongGrid.this.groupTextHeight, (i - 1) * SongGrid.this.boxWidth, SongGrid.this.groupTextHeight, SongGrid.this.boxWidth + 1);
                    }
                    g2d.setColor(Color.black);
                    g2d.drawString(sg.getName(), -SongGrid.this.groupTextHeight + 5, i++ * SongGrid.this.boxWidth - 4);
                    g2d.rotate(1.5707963267948966);
                }
            }
        };
        this.groupPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 2) != 0) {
                    JPopupMenu jp = SongGrid.this.groupsPopupMenu();
                    jp.show(SongGrid.this.groupPanel, e.getX(), e.getY());
                } else {
                    SongGroup g = (SongGroup)SongGrid.this.groups.get(e.getX() / SongGrid.this.boxWidth);
                    if (SongGrid.this.getCurrentGroup() != g) {
                        SongGrid.this.player.playGroup(g);
                    } else {
                        SongGrid.this.player.stop();
                    }
                    SongGrid.this.repaint();
                }
            }
        });
        vPanel.add(this.groupPanel);
        this.grid = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.gray);
                int i = 0;
                ArrayList groupsCopy = (ArrayList)SongGrid.this.groups.clone();
                for (SongGroup sg : groupsCopy) {
                    int j = 0;
                    if (sg == SongGrid.this.player.getCurrentGroup()) {
                        g.setColor(Color.lightGray);
                        g.fillRect(i * SongGrid.this.boxWidth, 0, SongGrid.this.boxWidth, this.getHeight());
                        g.setColor(Color.gray);
                    }
                    ArrayList partsCopy = (ArrayList)SongGrid.this.parts.clone();
                    for (SongPart sp : partsCopy) {
                        if (sg.contains(sp)) {
                            g.fillRect(i * SongGrid.this.boxWidth, j * SongGrid.this.boxWidth, SongGrid.this.boxWidth, SongGrid.this.boxWidth);
                        } else {
                            g.drawRect(i * SongGrid.this.boxWidth, j * SongGrid.this.boxWidth, SongGrid.this.boxWidth, SongGrid.this.boxWidth);
                        }
                        ++j;
                    }
                    ++i;
                }
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
        };
        this.grid.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SongGroup g = (SongGroup)SongGrid.this.groups.get(e.getX() / SongGrid.this.boxWidth);
                SongPart p = (SongPart)SongGrid.this.parts.get(e.getY() / SongGrid.this.boxWidth);
                if (g != null && p != null) {
                    if (g.contains(p)) {
                        g.remove(p);
                    } else {
                        g.add(p);
                    }
                    SongGrid.this.player.notifyCurrentGroupUpdated();
                }
                SongGrid.this.repaint();
            }
        });
        vPanel.add(this.grid);
        this.add(vPanel);
        BeadsKeys.addListener(new BeadsKeys.KeyboardListener(){

            @Override
            public void keyPressed(int keyCode) {
                if (keyCode == 39) {
                    if (SongGrid.this.player.getCurrentGroup() != null) {
                        int i = 0;
                        while (SongGrid.this.player.getCurrentGroup() != SongGrid.this.groups.get(i++)) {
                        }
                        if (i < SongGrid.this.groups.size()) {
                            if (BeadsKeys.keysDown[17]) {
                                SongGrid.this.player.playGroupNoFadeOut((SongGroup)SongGrid.this.groups.get(i));
                            } else {
                                SongGrid.this.player.playGroup((SongGroup)SongGrid.this.groups.get(i));
                            }
                            SongGrid.this.repaint();
                        }
                    }
                } else if (keyCode == 37) {
                    if (SongGrid.this.player.getCurrentGroup() != null) {
                        int i = 0;
                        while (SongGrid.this.player.getCurrentGroup() != SongGrid.this.groups.get(i++)) {
                        }
                        if (i > 1) {
                            if (BeadsKeys.keysDown[17]) {
                                SongGrid.this.player.playGroupNoFadeOut((SongGroup)SongGrid.this.groups.get(i - 2));
                            } else {
                                SongGrid.this.player.playGroup((SongGroup)SongGrid.this.groups.get(i - 2));
                            }
                            SongGrid.this.repaint();
                        }
                    }
                } else if (keyCode == 40) {
                    if (BeadsKeys.keysDown[17]) {
                        SongGrid.this.player.playGroupNoFadeOut((SongGroup)SongGrid.this.groups.get(0));
                    } else {
                        SongGrid.this.player.playGroup((SongGroup)SongGrid.this.groups.get(0));
                    }
                    SongGrid.this.repaint();
                } else if (keyCode == 38) {
                    if (BeadsKeys.keysDown[17]) {
                        SongGrid.this.player.playGroupNoFadeOut((SongGroup)SongGrid.this.groups.get(SongGrid.this.groups.size() - 1));
                    } else {
                        SongGrid.this.player.playGroup((SongGroup)SongGrid.this.groups.get(SongGrid.this.groups.size() - 1));
                    }
                    SongGrid.this.repaint();
                }
            }

            @Override
            public void keyReleased(int keyCode) {
            }
        });
        this.runUpdateThread();
    }

    private JPopupMenu groupsPopupMenu() {
        JPopupMenu jp = new JPopupMenu();
        JMenuItem newGroupItem = new JMenuItem("New Group...");
        newGroupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroPopup mp = new MicroPopup((Frame)SongGrid.this.getTopLevelAncestor(), "group name");
                String name = mp.getText();
                SongGrid.this.addSongGroup(new SongGroup(name));
                SongGrid.this.repaint();
            }
        });
        jp.add(newGroupItem);
        return jp;
    }

    public void addSongPart(SongPart sp) {
        this.parts.add(sp);
        this.environmentPanel.getSelectedChannel().addInput(sp);
        this.environmentPanel.getSelectedPathway().add(sp);
        sp.setClock(this.environmentPanel.getSelectedClock());
        this.resize();
    }

    public void addSongGroups(int numGroups) {
        int i = 0;
        while (i < numGroups) {
            this.addSongGroup();
            ++i;
        }
    }

    public void addSongGroup() {
        this.addSongGroup(new SongGroup("g" + (this.groups.size() + 1)));
    }

    public void addSongGroup(SongGroup sg) {
        this.groups.add(sg);
        this.resize();
    }

    public void resize() {
        this.groupPanel.setMinimumSize(new Dimension(this.groups.size() * this.boxWidth + 1, this.groupTextHeight));
        this.grid.setMinimumSize(new Dimension(this.groups.size() * this.boxWidth + 1, this.parts.size() * this.boxWidth));
        this.partPanel.setMinimumSize(new Dimension(this.partTextWidth, this.groupTextHeight + this.parts.size() * this.boxWidth + 1));
        this.groupPanel.setPreferredSize(new Dimension(this.groups.size() * this.boxWidth + 1, this.groupTextHeight));
        this.grid.setPreferredSize(new Dimension(this.groups.size() * this.boxWidth + 1, this.parts.size() * this.boxWidth + 1));
        this.partPanel.setPreferredSize(new Dimension(this.partTextWidth, this.groupTextHeight + this.parts.size() * this.boxWidth + 1));
        this.groupPanel.setMaximumSize(new Dimension(this.groups.size() * this.boxWidth + 1, this.groupTextHeight));
        this.grid.setMaximumSize(new Dimension(this.groups.size() * this.boxWidth + 1, this.parts.size() * this.boxWidth + 1));
        this.partPanel.setMaximumSize(new Dimension(this.partTextWidth, this.groupTextHeight + this.parts.size() * this.boxWidth + 1));
        this.groupPanel.revalidate();
        this.grid.revalidate();
        this.partPanel.revalidate();
    }

    private void runUpdateThread() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    SongGrid.this.repaint();
                    try {
                        9.sleep(100L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    public int getPartTextWidth() {
        return this.partTextWidth;
    }

    public void setPartTextWidth(int partTextWidth) {
        this.partTextWidth = partTextWidth;
    }

    public int getGroupTextHeight() {
        return this.groupTextHeight;
    }

    public void setGroupTextHeight(int groupTextHeight) {
        this.groupTextHeight = groupTextHeight;
    }

    public SongGroup getCurrentGroup() {
        return this.player.getCurrentGroup();
    }

    public void setCurrentGroup(SongGroup currentGroup) {
        this.player.setCurrentGroup(currentGroup);
    }

    public void setCurrentGroup(int i) {
        this.player.setCurrentGroup(this.groups.get(i));
    }
}

