/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.play;

import java.util.ArrayList;
import java.util.Hashtable;
import net.beadsproject.beads.play.SongPart;

public class SongGroup {
    private final ArrayList<SongPart> parts;
    private final Hashtable<SongPart, Boolean> partVisibility;
    private String name;
    private int flipQuantisation;

    public SongGroup(String name) {
        this.setName(name);
        this.parts = new ArrayList();
        this.partVisibility = new Hashtable();
        this.flipQuantisation = 4;
    }

    public void add(SongPart sp) {
        this.parts.add(sp);
        this.partVisibility.put(sp, true);
    }

    public void remove(SongPart sp) {
        this.parts.remove(sp);
        this.partVisibility.remove(sp);
    }

    public boolean contains(SongPart sp) {
        return this.parts.contains(sp);
    }

    public ArrayList<SongPart> parts() {
        return this.parts;
    }

    public boolean getPartVisibility(SongPart sp) {
        return this.partVisibility.get(sp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String toString() {
        return String.valueOf(this.getName()) + " (" + this.getClass().getSimpleName() + ")";
    }

    public void setFlipQuantisation(int flipQuantisation) {
        this.flipQuantisation = flipQuantisation;
    }

    public int getFlipQuantisation() {
        return this.flipQuantisation;
    }
}

