/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class AllpassFilter
extends IIRFilter
implements DataBeadReceiver {
    protected float g;
    protected int maxDelay = 1;
    protected int delay = 1;
    protected int ind = 0;
    protected int bufLen;
    protected UGen delayUGen;
    protected UGen gUGen;
    protected boolean isDelayStatic;
    protected boolean isGStatic;
    protected float[] xn;
    protected float[] yn;

    public AllpassFilter(AudioContext audioContext, int n, int n2, float f) {
        this(audioContext, n);
        this.setDelay(n2).setG(f);
    }

    public AllpassFilter(AudioContext audioContext, int n, UGen uGen, float f) {
        this(audioContext, n);
        this.setDelay(uGen).setG(f);
    }

    public AllpassFilter(AudioContext audioContext, int n, int n2, UGen uGen) {
        this(audioContext, n);
        this.setDelay(n2).setG(uGen);
    }

    public AllpassFilter(AudioContext audioContext, int n, UGen uGen, UGen uGen2) {
        this(audioContext, n);
        this.setDelay(uGen).setG(uGen2);
    }

    private AllpassFilter(AudioContext audioContext, int n) {
        super(audioContext, 1, 1);
        this.maxDelay = Math.max(n, 1);
        this.bufLen = this.maxDelay + 1;
        this.xn = new float[this.bufLen];
        this.yn = new float[this.bufLen];
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufIn[0];
        float[] fArray2 = this.bufOut[0];
        if (this.isDelayStatic && this.isGStatic) {
            int n = (this.ind + this.bufLen - this.delay) % this.bufLen;
            for (int i = 0; i < this.bufferSize; ++i) {
                this.xn[this.ind] = fArray[i];
                fArray2[i] = this.yn[this.ind] = this.xn[n] + this.g * (this.yn[n] - this.xn[this.ind]);
                n = (n + 1) % this.bufLen;
                this.ind = (this.ind + 1) % this.bufLen;
            }
        } else {
            this.gUGen.update();
            this.delayUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.delay = (int)this.gUGen.getValue(0, i);
                if (this.delay < 1) {
                    this.delay = 1;
                } else if (this.delay > this.maxDelay) {
                    this.delay = this.maxDelay;
                }
                int n = (this.ind + this.bufLen - this.delay) % this.bufLen;
                this.xn[this.ind] = fArray[i];
                fArray2[i] = this.yn[this.ind] = this.xn[n] + this.gUGen.getValue(0, i) * (this.yn[n] - this.xn[this.ind]);
                this.ind = (this.ind + 1) % this.bufLen;
            }
            this.g = this.gUGen.getValue(0, this.bufferSize - 1);
        }
    }

    public float getG() {
        return this.g;
    }

    public AllpassFilter setG(float f) {
        this.g = f;
        if (this.isGStatic) {
            this.gUGen.setValue(f);
        } else {
            this.gUGen = new Static(this.context, f);
            this.isGStatic = true;
        }
        return this;
    }

    public AllpassFilter setG(UGen uGen) {
        if (uGen == null) {
            this.setG(this.g);
        } else {
            this.gUGen = uGen;
            uGen.update();
            this.g = uGen.getValue();
            this.isGStatic = false;
        }
        return this;
    }

    public UGen getGUGen() {
        if (this.isGStatic) {
            return null;
        }
        return this.gUGen;
    }

    public int getDelay() {
        return this.delay;
    }

    public AllpassFilter setDelay(int n) {
        this.delay = n > this.maxDelay ? this.maxDelay : (n < 1 ? 1 : n);
        if (this.isDelayStatic) {
            this.delayUGen.setValue(this.delay);
        } else {
            this.delayUGen = new Static(this.context, (float)this.delay);
            this.isDelayStatic = true;
        }
        return this;
    }

    public AllpassFilter setDelay(UGen uGen) {
        if (uGen == null) {
            this.setDelay(this.delay);
        } else {
            this.delayUGen = uGen;
            uGen.update();
            this.delay = (int)uGen.getValue();
            if (this.delay < 0) {
                this.delay = 0;
            } else if (this.delay > this.maxDelay) {
                this.delay = this.maxDelay;
            }
            this.isDelayStatic = false;
        }
        return this;
    }

    public UGen getDelayUGen() {
        if (this.isDelayStatic) {
            return null;
        }
        return this.delayUGen;
    }

    public AllpassFilter setParams(DataBead dataBead) {
        if (dataBead != null) {
            Object object = dataBead.get("delay");
            if (object != null) {
                if (object instanceof UGen) {
                    this.setDelay((UGen)object);
                } else {
                    this.setDelay((int)dataBead.getFloat("delay", this.delay));
                }
            }
            if ((object = dataBead.get("g")) != null) {
                if (object instanceof UGen) {
                    this.setG((UGen)object);
                } else {
                    this.setG(dataBead.getFloat("g", this.g));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.setParams((DataBead)bead);
        }
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isDelayStatic) {
            dataBead.put("delay", (Object)this.delay);
        } else {
            dataBead.put("delay", (Object)this.delayUGen);
        }
        if (this.isGStatic) {
            dataBead.put("g", (Object)Float.valueOf(this.g));
        } else {
            dataBead.put("g", (Object)this.gUGen);
        }
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("delay", (Object)this.delay);
        dataBead.put("g", (Object)Float.valueOf(this.g));
        return dataBead;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        this.setParams(dataBead);
        return this;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float f) {
        float[] fArray = new float[this.delay + 1];
        float[] fArray2 = new float[this.delay + 1];
        fArray2[0] = fArray[this.delay] = -this.g;
        fArray2[this.delay] = 1.0f;
        fArray[0] = 1.0f;
        return AllpassFilter.calculateFilterResponse(fArray2, fArray, f, this.context.getSampleRate());
    }
}

