/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class BiquadFilter
extends IIRFilter
implements DataBeadReceiver {
    public static final Type LP = Type.LP;
    public static final Type HP = Type.HP;
    public static final Type BP_SKIRT = Type.BP_SKIRT;
    public static final Type BP_PEAK = Type.BP_PEAK;
    public static final Type NOTCH = Type.NOTCH;
    public static final Type AP = Type.AP;
    public static final Type PEAKING_EQ = Type.PEAKING_EQ;
    public static final Type LOW_SHELF = Type.LOW_SHELF;
    public static final Type HIGH_SHELF = Type.HIGH_SHELF;
    public static final Type BUTTERWORTH_LP = Type.BUTTERWORTH_LP;
    public static final Type BUTTERWORTH_HP = Type.BUTTERWORTH_HP;
    public static final Type BESSEL_LP = Type.BESSEL_LP;
    public static final Type BESSEL_HP = Type.BESSEL_HP;
    public static final Type CUSTOM_FILTER = Type.CUSTOM_FILTER;
    protected float a0 = 1.0f;
    protected float a1 = 0.0f;
    protected float a2 = 0.0f;
    protected float b0 = 0.0f;
    protected float b1 = 0.0f;
    protected float b2 = 0.0f;
    protected int channels = super.getOuts();
    protected float freq = 100.0f;
    protected float q = 1.0f;
    protected float gain = 0.0f;
    protected Type type = null;
    protected float samplingfreq;
    protected float two_pi_over_sf;
    protected float pi_over_sf;
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    protected double w = 0.0;
    protected double ampResponse = 0.0;
    protected double phaseResponse = 0.0;
    protected double phaseDelay = 0.0;
    protected double frReal = 0.0;
    protected double frImag = 0.0;
    protected float[] bo1m;
    protected float[] bo2m;
    protected float[] bi1m = new float[this.channels];
    protected float[] bi2m = new float[this.channels];
    protected float bo1 = 0.0f;
    protected float bo2 = 0.0f;
    protected float bi1 = 0.0f;
    protected float bi2 = 0.0f;
    protected boolean cuedInputMemory = false;
    protected boolean cuedOutputMemory = false;
    protected float[] cbo1m;
    protected float[] cbo2m;
    protected float[] cbi1m;
    protected float[] cbi2m;
    protected float cbo1 = 0.0f;
    protected float cbo2 = 0.0f;
    protected float cbi1 = 0.0f;
    protected float cbi2 = 0.0f;
    protected ValCalculator vc;
    protected UGen freqUGen;
    protected UGen qUGen;
    protected UGen gainUGen;
    protected boolean isFreqStatic;
    protected boolean isQStatic;
    protected boolean isGainStatic;
    protected boolean areAllStatic;

    public BiquadFilter(AudioContext audioContext, int n) {
        this(audioContext, n, LP);
    }

    public BiquadFilter(AudioContext audioContext, int n, Type type) {
        super(audioContext, n, n);
        this.bo1m = new float[this.channels];
        this.bo2m = new float[this.channels];
        this.samplingfreq = audioContext.getSampleRate();
        this.two_pi_over_sf = (float)(Math.PI * 2 / (double)this.samplingfreq);
        this.pi_over_sf = (float)(Math.PI / (double)this.samplingfreq);
        this.setType(type);
        this.setFrequency(this.freq).setQ(this.q).setGain(this.gain);
    }

    public BiquadFilter(AudioContext audioContext, int n, DataBead dataBead) {
        this(audioContext, n, LP);
        this.setParams(dataBead);
    }

    public BiquadFilter(AudioContext audioContext, int n, Type type, DataBead dataBead) {
        this(audioContext, n, type);
        this.setParams(dataBead);
    }

    public BiquadFilter(AudioContext audioContext, Type type, float f, float f2) {
        this(audioContext, 1, type);
        this.setFrequency(f).setQ(f2);
    }

    public BiquadFilter(AudioContext audioContext, Type type, UGen uGen, float f) {
        this(audioContext, 1, type);
        this.setFrequency(uGen).setQ(f);
    }

    public BiquadFilter(AudioContext audioContext, Type type, float f, UGen uGen) {
        this(audioContext, 1, type);
        this.setFrequency(f).setQ(uGen);
    }

    public BiquadFilter(AudioContext audioContext, Type type, UGen uGen, UGen uGen2) {
        this(audioContext, 1, type);
        this.setFrequency(uGen).setQ(uGen2);
    }

    private void checkStaticStatus() {
        if (this.isFreqStatic && this.isQStatic && this.isGainStatic) {
            this.areAllStatic = true;
            this.vc.calcVals();
        } else {
            this.areAllStatic = false;
        }
    }

    @Override
    public void calculateBuffer() {
        block20: {
            int n;
            block19: {
                if (this.channels != 1) break block19;
                if (this.cuedInputMemory) {
                    this.bi1 = this.cbi1;
                    this.bi2 = this.cbi2;
                    this.cuedInputMemory = false;
                }
                if (this.cuedOutputMemory) {
                    this.bo1 = this.cbo1;
                    this.bo2 = this.cbo2;
                    this.cuedOutputMemory = false;
                }
                float[] fArray = this.bufIn[0];
                float[] fArray2 = this.bufOut[0];
                if (this.areAllStatic) {
                    fArray2[0] = (this.b0 * fArray[0] + this.b1 * this.bi1 + this.b2 * this.bi2 - this.a1 * this.bo1 - this.a2 * this.bo2) / this.a0;
                    fArray2[1] = (this.b0 * fArray[1] + this.b1 * fArray[0] + this.b2 * this.bi1 - this.a1 * fArray2[0] - this.a2 * this.bo1) / this.a0;
                    for (int i = 2; i < this.bufferSize; ++i) {
                        fArray2[i] = (this.b0 * fArray[i] + this.b1 * fArray[i - 1] + this.b2 * fArray[i - 2] - this.a1 * fArray2[i - 1] - this.a2 * fArray2[i - 2]) / this.a0;
                    }
                } else {
                    this.freqUGen.update();
                    this.qUGen.update();
                    this.gainUGen.update();
                    this.freq = this.freqUGen.getValue(0, 0);
                    this.q = this.qUGen.getValue(0, 0);
                    this.gain = this.gainUGen.getValue(0, 0);
                    this.vc.calcVals();
                    fArray2[0] = (this.b0 * fArray[0] + this.b1 * this.bi1 + this.b2 * this.bi2 - this.a1 * this.bo1 - this.a2 * this.bo2) / this.a0;
                    this.freq = this.freqUGen.getValue(0, 1);
                    this.q = this.qUGen.getValue(0, 1);
                    this.gain = this.gainUGen.getValue(0, 1);
                    this.vc.calcVals();
                    fArray2[1] = (this.b0 * fArray[1] + this.b1 * fArray[0] + this.b2 * this.bi1 - this.a1 * fArray2[0] - this.a2 * this.bo1) / this.a0;
                    for (int i = 2; i < this.bufferSize; ++i) {
                        this.freq = this.freqUGen.getValue(0, i);
                        this.q = this.qUGen.getValue(0, i);
                        this.gain = this.gainUGen.getValue(0, i);
                        this.vc.calcVals();
                        fArray2[i] = (this.b0 * fArray[i] + this.b1 * fArray[i - 1] + this.b2 * fArray[i - 2] - this.a1 * fArray2[i - 1] - this.a2 * fArray2[i - 2]) / this.a0;
                    }
                }
                this.bi1 = fArray[this.bufferSize - 1];
                this.bi2 = fArray[this.bufferSize - 2];
                this.bo1 = fArray2[this.bufferSize - 1];
                this.bo2 = fArray2[this.bufferSize - 2];
                if (!Float.isNaN(this.bo1)) break block20;
                this.reset();
                break block20;
            }
            if (this.cuedInputMemory) {
                for (n = 0; n < this.channels; ++n) {
                    this.bi1m[n] = this.cbi1m[n];
                    this.bi2m[n] = this.cbi2m[n];
                }
                this.cuedInputMemory = false;
            }
            if (this.cuedOutputMemory) {
                for (n = 0; n < this.channels; ++n) {
                    this.bo1m[n] = this.cbo1m[n];
                    this.bo2m[n] = this.cbo2m[n];
                }
                this.cuedOutputMemory = false;
            }
            if (this.areAllStatic) {
                for (n = 0; n < this.channels; ++n) {
                    float[] fArray = this.bufIn[n];
                    float[] fArray3 = this.bufOut[n];
                    fArray3[0] = (this.b0 * fArray[0] + this.b1 * this.bi1m[n] + this.b2 * this.bi2m[n] - this.a1 * this.bo1m[n] - this.a2 * this.bo2m[n]) / this.a0;
                    fArray3[1] = (this.b0 * fArray[1] + this.b1 * fArray[0] + this.b2 * this.bi1m[n] - this.a1 * fArray3[0] - this.a2 * this.bo1m[n]) / this.a0;
                    for (int i = 2; i < this.bufferSize; ++i) {
                        fArray3[i] = (this.b0 * fArray[i] + this.b1 * fArray[i - 1] + this.b2 * fArray[i - 2] - this.a1 * fArray3[i - 1] - this.a2 * fArray3[i - 2]) / this.a0;
                    }
                    this.bi2m[n] = fArray[this.bufferSize - 2];
                    this.bi1m[n] = fArray[this.bufferSize - 1];
                    this.bo2m[n] = fArray3[this.bufferSize - 2];
                    this.bo1m[n] = fArray3[this.bufferSize - 1];
                    if (!Float.isNaN(this.bo1m[n])) continue;
                    this.reset();
                }
            } else {
                this.freqUGen.update();
                this.qUGen.update();
                this.gainUGen.update();
                this.freq = this.freqUGen.getValue(0, 0);
                this.q = this.qUGen.getValue(0, 0);
                this.gain = this.gainUGen.getValue(0, 0);
                this.vc.calcVals();
                for (n = 0; n < this.channels; ++n) {
                    this.bufOut[n][0] = (this.b0 * this.bufIn[n][0] + this.b1 * this.bi1m[n] + this.b2 * this.bi2m[n] - this.a1 * this.bo1m[n] - this.a2 * this.bo2m[n]) / this.a0;
                }
                this.freq = this.freqUGen.getValue(0, 1);
                this.q = this.qUGen.getValue(0, 1);
                this.gain = this.gainUGen.getValue(0, 1);
                this.vc.calcVals();
                for (n = 0; n < this.channels; ++n) {
                    this.bufOut[n][1] = (this.b0 * this.bufIn[n][1] + this.b1 * this.bufIn[n][0] + this.b2 * this.bi1m[n] - this.a1 * this.bufOut[n][0] - this.a2 * this.bo1m[n]) / this.a0;
                }
                for (n = 2; n < this.bufferSize; ++n) {
                    this.freq = this.freqUGen.getValue(0, n);
                    this.q = this.qUGen.getValue(0, n);
                    this.gain = this.gainUGen.getValue(0, n);
                    this.vc.calcVals();
                    for (int i = 0; i < this.channels; ++i) {
                        this.bufOut[i][n] = (this.b0 * this.bufIn[i][n] + this.b1 * this.bufIn[i][n - 1] + this.b2 * this.bufIn[i][n - 2] - this.a1 * this.bufOut[i][n - 1] - this.a2 * this.bufOut[i][n - 2]) / this.a0;
                    }
                }
                for (n = 0; n < this.channels; ++n) {
                    this.bi2m[n] = this.bufIn[n][this.bufferSize - 2];
                    this.bi1m[n] = this.bufIn[n][this.bufferSize - 1];
                    this.bo2m[n] = this.bufOut[n][this.bufferSize - 2];
                    this.bo1m[n] = this.bufOut[n][this.bufferSize - 1];
                    if (!Float.isNaN(this.bo1m[n])) continue;
                    this.reset();
                }
            }
        }
    }

    public void reset() {
        for (int i = 0; i < this.channels; ++i) {
            this.bi1m[i] = 0.0f;
            this.bi2m[i] = 0.0f;
            this.bo1m[i] = 0.0f;
            this.bo2m[i] = 0.0f;
        }
        this.bi1 = 0.0f;
        this.bi2 = 0.0f;
        this.bo1 = 0.0f;
        this.bo2 = 0.0f;
    }

    public BiquadFilter setParams(DataBead dataBead) {
        if (dataBead != null) {
            Object object = dataBead.get("type");
            if (object instanceof Number) {
                this.setType(((Number)object).intValue());
            } else if (object instanceof Type) {
                this.setType((Type)((Object)object));
            }
            object = dataBead.get("frequency");
            if (object != null) {
                if (object instanceof UGen) {
                    this.setFrequency((UGen)object);
                } else {
                    this.setFrequency(dataBead.getFloat("frequency", this.freq));
                }
            }
            if ((object = dataBead.get("q")) != null) {
                if (object instanceof UGen) {
                    this.setQ((UGen)object);
                } else {
                    this.setQ(dataBead.getFloat("q", this.q));
                }
            }
            if ((object = dataBead.get("gain")) != null) {
                if (object instanceof UGen) {
                    this.setGain((UGen)object);
                } else {
                    this.setGain(dataBead.getFloat("gain", this.gain));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.setParams((DataBead)bead);
        }
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        this.setParams(dataBead);
        return this;
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isFreqStatic) {
            dataBead.put("frequency", (Object)Float.valueOf(this.freq));
        } else {
            dataBead.put("frequency", (Object)this.freqUGen);
        }
        if (this.isQStatic) {
            dataBead.put("q", (Object)Float.valueOf(this.q));
        } else {
            dataBead.put("q", (Object)this.qUGen);
        }
        if (this.isGainStatic) {
            dataBead.put("gain", (Object)Float.valueOf(this.gain));
        } else {
            dataBead.put("gain", (Object)this.gainUGen);
        }
        dataBead.put("type", (Object)this.type);
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("frequency", (Object)Float.valueOf(this.freq));
        dataBead.put("q", (Object)Float.valueOf(this.q));
        dataBead.put("gain", (Object)Float.valueOf(this.gain));
        dataBead.put("type", (Object)this.type);
        return dataBead;
    }

    public BiquadFilter setType(Type type) {
        if (type != this.type || this.vc == null) {
            Type type2 = this.type;
            this.type = type;
            switch (this.type) {
                case LP: {
                    this.vc = new LPValCalculator();
                    break;
                }
                case HP: {
                    this.vc = new HPValCalculator();
                    break;
                }
                case BP_SKIRT: {
                    this.vc = new BPSkirtValCalculator();
                    break;
                }
                case BP_PEAK: {
                    this.vc = new BPPeakValCalculator();
                    break;
                }
                case NOTCH: {
                    this.vc = new NotchValCalculator();
                    break;
                }
                case AP: {
                    this.vc = new APValCalculator();
                    break;
                }
                case PEAKING_EQ: {
                    this.vc = new PeakingEQValCalculator();
                    break;
                }
                case LOW_SHELF: {
                    this.vc = new LowShelfValCalculator();
                    break;
                }
                case HIGH_SHELF: {
                    this.vc = new HighShelfValCalculator();
                    break;
                }
                case BUTTERWORTH_LP: {
                    this.vc = new ButterworthLPValCalculator();
                    break;
                }
                case BUTTERWORTH_HP: {
                    this.vc = new ButterworthHPValCalculator();
                    break;
                }
                case BESSEL_LP: {
                    this.vc = new BesselLPValCalculator();
                    break;
                }
                case BESSEL_HP: {
                    this.vc = new BesselHPValCalculator();
                    break;
                }
                default: {
                    this.type = type2;
                }
            }
            this.vc.calcVals();
        }
        return this;
    }

    @Deprecated
    public BiquadFilter setType(int n) {
        Type type = null;
        switch (n) {
            case 0: {
                type = LP;
                break;
            }
            case 1: {
                type = HP;
                break;
            }
            case 2: {
                type = BP_SKIRT;
                break;
            }
            case 3: {
                type = BP_PEAK;
                break;
            }
            case 4: {
                type = NOTCH;
                break;
            }
            case 5: {
                type = AP;
                break;
            }
            case 6: {
                type = PEAKING_EQ;
                break;
            }
            case 7: {
                type = LOW_SHELF;
                break;
            }
            case 8: {
                type = HIGH_SHELF;
                break;
            }
            case 9: {
                type = BUTTERWORTH_LP;
                break;
            }
            case 10: {
                type = BUTTERWORTH_HP;
                break;
            }
            case 11: {
                type = BESSEL_LP;
                break;
            }
            case 12: {
                type = BESSEL_HP;
                break;
            }
            case 100: {
                type = CUSTOM_FILTER;
            }
        }
        if (type != this.type || this.vc == null) {
            Type type2 = this.type;
            this.type = type;
            switch (this.type) {
                case LP: {
                    this.vc = new LPValCalculator();
                    break;
                }
                case HP: {
                    this.vc = new HPValCalculator();
                    break;
                }
                case BP_SKIRT: {
                    this.vc = new BPSkirtValCalculator();
                    break;
                }
                case BP_PEAK: {
                    this.vc = new BPPeakValCalculator();
                    break;
                }
                case NOTCH: {
                    this.vc = new NotchValCalculator();
                    break;
                }
                case AP: {
                    this.vc = new APValCalculator();
                    break;
                }
                case PEAKING_EQ: {
                    this.vc = new PeakingEQValCalculator();
                    break;
                }
                case LOW_SHELF: {
                    this.vc = new LowShelfValCalculator();
                    break;
                }
                case HIGH_SHELF: {
                    this.vc = new HighShelfValCalculator();
                    break;
                }
                case BUTTERWORTH_LP: {
                    this.vc = new ButterworthLPValCalculator();
                    break;
                }
                case BUTTERWORTH_HP: {
                    this.vc = new ButterworthHPValCalculator();
                    break;
                }
                case BESSEL_LP: {
                    this.vc = new BesselLPValCalculator();
                    break;
                }
                case BESSEL_HP: {
                    this.vc = new BesselHPValCalculator();
                    break;
                }
                default: {
                    this.type = type2;
                }
            }
            this.vc.calcVals();
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public float getFrequency() {
        return this.freq;
    }

    public BiquadFilter setFrequency(float f) {
        this.freq = f;
        if (this.isFreqStatic) {
            this.freqUGen.setValue(f);
        } else {
            this.freqUGen = new Static(this.context, f);
            this.isFreqStatic = true;
            this.checkStaticStatus();
        }
        this.vc.calcVals();
        return this;
    }

    public BiquadFilter setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = uGen;
            uGen.update();
            this.freq = uGen.getValue();
            this.isFreqStatic = false;
            this.areAllStatic = false;
        }
        this.vc.calcVals();
        return this;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public BiquadFilter setFreq(float f) {
        return this.setFrequency(f);
    }

    @Deprecated
    public BiquadFilter setFreq(UGen uGen) {
        return this.setFrequency(uGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public BiquadFilter setQ(float f) {
        this.q = f;
        if (this.isQStatic) {
            this.qUGen.setValue(f);
        } else {
            this.qUGen = new Static(this.context, f);
            this.isQStatic = true;
            this.checkStaticStatus();
        }
        this.vc.calcVals();
        return this;
    }

    public BiquadFilter setQ(UGen uGen) {
        if (uGen == null) {
            this.setQ(this.q);
        } else {
            this.qUGen = uGen;
            this.qUGen.update();
            this.q = this.freqUGen.getValue();
            this.isQStatic = false;
            this.areAllStatic = false;
        }
        this.vc.calcVals();
        return this;
    }

    public float getQ() {
        return this.q;
    }

    public UGen getQUGen() {
        if (this.isQStatic) {
            return null;
        }
        return this.qUGen;
    }

    public BiquadFilter setGain(float f) {
        this.gain = f;
        if (this.isGainStatic) {
            this.gainUGen.setValue(f);
        } else {
            this.gainUGen = new Static(this.context, f);
            this.isGainStatic = true;
            this.checkStaticStatus();
        }
        this.vc.calcVals();
        return this;
    }

    public BiquadFilter setGain(UGen uGen) {
        if (uGen == null) {
            this.setGain(this.gain);
        } else {
            this.gainUGen = uGen;
            this.gainUGen.update();
            this.gain = this.freqUGen.getValue();
            this.isGainStatic = false;
            this.areAllStatic = false;
        }
        this.vc.calcVals();
        return this;
    }

    public float getGain() {
        return this.gain;
    }

    public UGen getGainUGen() {
        if (this.isGainStatic) {
            return null;
        }
        return this.gainUGen;
    }

    public BiquadFilter loadMemory(float f, float f2, float f3, float f4) {
        this.loadInputMemory(f, f2);
        this.loadOutputMemory(f3, f4);
        return this;
    }

    public BiquadFilter loadMemory(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.loadInputMemory(fArray, fArray2);
        this.loadOutputMemory(fArray3, fArray4);
        return this;
    }

    public BiquadFilter loadInputMemory(float f, float f2) {
        if (this.channels == 1) {
            this.bi1 = f;
            this.bi2 = f2;
        } else {
            for (int i = 0; i < this.channels; ++i) {
                this.bi1m[i] = f;
                this.bi2m[i] = f2;
            }
        }
        this.cuedInputMemory = true;
        return this;
    }

    public BiquadFilter loadInputMemory(float[] fArray, float[] fArray2) {
        int n = Math.min(fArray.length, fArray2.length);
        if (this.channels == 1 && n > 0) {
            this.bi1 = fArray[0];
            this.bi2 = fArray2[0];
            this.cuedInputMemory = true;
        } else {
            for (int i = 0; i < Math.min(this.channels, n); ++i) {
                this.cbi1m[i] = fArray[i];
                this.cbi2m[i] = fArray2[i];
                this.cuedInputMemory = true;
            }
        }
        return this;
    }

    public BiquadFilter loadOutputMemory(float f, float f2) {
        if (this.channels == 1) {
            this.cbo1 = f;
            this.cbo2 = f2;
        } else {
            for (int i = 0; i < this.channels; ++i) {
                this.cbo1m[i] = f;
                this.cbo2m[i] = f2;
            }
        }
        this.cuedOutputMemory = true;
        return this;
    }

    public BiquadFilter loadOutputMemory(float[] fArray, float[] fArray2) {
        int n = Math.min(fArray.length, fArray2.length);
        if (this.channels == 1 && n > 0) {
            this.bo1 = fArray[0];
            this.bo2 = fArray2[0];
            this.cuedOutputMemory = true;
        } else {
            for (int i = 0; i < Math.min(this.channels, n); ++i) {
                this.bo1m[i] = fArray[i];
                this.bo2m[i] = fArray2[i];
                this.cuedOutputMemory = true;
            }
        }
        return this;
    }

    public float[] getCoefficients() {
        return new float[]{this.a0, this.a1, this.a2, this.b0, this.b1, this.b2};
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float f) {
        return BiquadFilter.calculateFilterResponse(new float[]{this.b0, this.b1, this.b2}, new float[]{this.a0, this.a1, this.a2}, f, this.samplingfreq);
    }

    public BiquadFilter setCustomType(CustomCoeffCalculator customCoeffCalculator) {
        this.vc = new CustomValCalculator(customCoeffCalculator);
        this.vc.calcVals();
        return this;
    }

    public class CustomCoeffCalculator {
        public float a0 = 1.0f;
        public float a1 = 0.0f;
        public float a2 = 0.0f;
        public float b0 = 0.0f;
        public float b1 = 0.0f;
        public float b2 = 0.0f;
        protected float sampFreq;
        protected float two_pi_over_sf;

        CustomCoeffCalculator(float f) {
            this.setSamplingFrequency(f);
        }

        CustomCoeffCalculator() {
            this.setSamplingFrequency(44100.0f);
        }

        public void setSamplingFrequency(float f) {
            this.sampFreq = f;
            this.two_pi_over_sf = (float)(Math.PI * 2 / (double)f);
        }

        public void calcCoeffs(float f, float f2, float f3) {
        }
    }

    private class CustomValCalculator
    extends ValCalculator {
        CustomCoeffCalculator ccc;

        CustomValCalculator(CustomCoeffCalculator customCoeffCalculator) {
            this.ccc = customCoeffCalculator;
        }

        @Override
        public void calcVals() {
            this.ccc.calcCoeffs(BiquadFilter.this.freq, BiquadFilter.this.q, BiquadFilter.this.gain);
            BiquadFilter.this.a0 = this.ccc.a0;
            BiquadFilter.this.a1 = this.ccc.a1;
            BiquadFilter.this.a2 = this.ccc.a2;
            BiquadFilter.this.b0 = this.ccc.b0;
            BiquadFilter.this.b1 = this.ccc.b1;
            BiquadFilter.this.b2 = this.ccc.b2;
        }
    }

    private class BesselHPValCalculator
    extends ValCalculator {
        private BesselHPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.tan(BiquadFilter.this.pi_over_sf * BiquadFilter.this.freq);
            float f2 = f * f;
            BiquadFilter.this.b0 = 3.0f;
            BiquadFilter.this.b2 = 3.0f;
            BiquadFilter.this.b1 = -6.0f;
            BiquadFilter.this.a0 = f2 + 3.0f * f + 3.0f;
            BiquadFilter.this.a1 = 2.0f * f2 - 6.0f;
            BiquadFilter.this.a2 = f2 - 3.0f * f + 3.0f;
        }
    }

    private class BesselLPValCalculator
    extends ValCalculator {
        private BesselLPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.tan(BiquadFilter.this.pi_over_sf * BiquadFilter.this.freq);
            BiquadFilter.this.b2 = BiquadFilter.this.b0 = 3.0f * f * f;
            BiquadFilter.this.b1 = 2.0f * BiquadFilter.this.b0;
            BiquadFilter.this.a0 = 1.0f + 3.0f * f + BiquadFilter.this.b0;
            BiquadFilter.this.a1 = -2.0f + BiquadFilter.this.b1;
            BiquadFilter.this.a2 = 1.0f - 3.0f * f + BiquadFilter.this.b0;
        }
    }

    private class ButterworthBPValCalculator
    extends ValCalculator {
        private ButterworthBPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.pi_over_sf * 0.5f * BiquadFilter.this.freq / BiquadFilter.this.q;
            float f2 = (float)Math.sqrt(1.0f + 4.0f * BiquadFilter.this.q * BiquadFilter.this.q);
            float f3 = (float)Math.tan(f * (f2 - 1.0f));
            float f4 = (float)Math.tan(f * (f2 + 1.0f));
            float f5 = f3 * f4 + 1.0f;
            BiquadFilter.this.b0 = f4 - f3;
            BiquadFilter.this.b2 = -BiquadFilter.this.b0;
            BiquadFilter.this.b1 = 0.0f;
            BiquadFilter.this.a0 = f5 + BiquadFilter.this.b0;
            BiquadFilter.this.a1 = 2.0f * (f5 - 2.0f);
            BiquadFilter.this.a2 = f5 - BiquadFilter.this.b0;
        }
    }

    private class ButterworthHPValCalculator
    extends ValCalculator {
        private ButterworthHPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.tan(BiquadFilter.this.freq * BiquadFilter.this.pi_over_sf);
            float f2 = f * f + 1.0f;
            BiquadFilter.this.b2 = 1.0f;
            BiquadFilter.this.b0 = 1.0f;
            BiquadFilter.this.b1 = -2.0f;
            BiquadFilter.this.a0 = f2 + SQRT2 * f;
            BiquadFilter.this.a1 = 2.0f * (f2 - 2.0f);
            BiquadFilter.this.a2 = f2 - SQRT2 * f;
        }
    }

    private class ButterworthLPValCalculator
    extends ValCalculator {
        private ButterworthLPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.tan(BiquadFilter.this.freq * BiquadFilter.this.pi_over_sf);
            BiquadFilter.this.b0 = BiquadFilter.this.b2 = f * f;
            BiquadFilter.this.b1 = 2.0f * BiquadFilter.this.b0;
            BiquadFilter.this.a0 = BiquadFilter.this.b0 + SQRT2 * f + 1.0f;
            BiquadFilter.this.a1 = 2.0f * (BiquadFilter.this.b0 - 1.0f);
            BiquadFilter.this.a2 = BiquadFilter.this.b0 - SQRT2 * f + 1.0f;
        }
    }

    private class HighShelfValCalculator
    extends ValCalculator {
        private HighShelfValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.pow(10.0, (double)BiquadFilter.this.gain * 0.025);
            float f2 = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f3 = (float)Math.cos(f2);
            float f4 = (float)(Math.sin(f2) / (double)BiquadFilter.this.q * 0.5);
            float f5 = 2.0f * f4 * (float)Math.sqrt(f);
            float f6 = (f - 1.0f) * f3;
            BiquadFilter.this.b0 = f * (f + 1.0f + f6 + f5);
            BiquadFilter.this.b1 = -2.0f * f * (f - 1.0f + (f + 1.0f) * f3);
            BiquadFilter.this.b2 = f * (f + 1.0f + f6 - f5);
            BiquadFilter.this.a0 = f + 1.0f - f6 + f5;
            BiquadFilter.this.a1 = 2.0f * (f - 1.0f - (f + 1.0f) * f3);
            BiquadFilter.this.a2 = f + 1.0f - f6 - f5;
        }
    }

    private class LowShelfValCalculator
    extends ValCalculator {
        private LowShelfValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.pow(10.0, (double)BiquadFilter.this.gain * 0.025);
            float f2 = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f3 = (float)Math.cos(f2);
            float f4 = (float)(Math.sin(f2) / (double)BiquadFilter.this.q * 0.5);
            float f5 = 2.0f * f4 * (float)Math.sqrt(f);
            float f6 = (f - 1.0f) * f3;
            BiquadFilter.this.b0 = f * (f + 1.0f - f6 + f5);
            BiquadFilter.this.b1 = 2.0f * f * (f - 1.0f - (f + 1.0f) * f3);
            BiquadFilter.this.b2 = f * (f + 1.0f - f6 - f5);
            BiquadFilter.this.a0 = f + 1.0f + f6 + f5;
            BiquadFilter.this.a1 = -2.0f * (f - 1.0f + (f + 1.0f) * f3);
            BiquadFilter.this.a2 = f + 1.0f + f6 - f5;
        }
    }

    private class PeakingEQValCalculator
    extends ValCalculator {
        private PeakingEQValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = (float)Math.pow(10.0, (double)BiquadFilter.this.gain * 0.025);
            float f2 = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f3 = (float)(Math.sin(f2) / (double)BiquadFilter.this.q * 0.5);
            BiquadFilter.this.b0 = 1.0f + f3 * f;
            BiquadFilter.this.b2 = 2.0f - BiquadFilter.this.b0;
            BiquadFilter.this.a1 = BiquadFilter.this.b1 = -2.0f * (float)Math.cos(f2);
            BiquadFilter.this.a0 = 1.0f + f3 / f;
            BiquadFilter.this.a2 = 2.0f - BiquadFilter.this.a0;
        }
    }

    private class APValCalculator
    extends ValCalculator {
        private APValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f2 = (float)(Math.sin(f) / (double)BiquadFilter.this.q * 0.5);
            BiquadFilter.this.a2 = BiquadFilter.this.b0 = 1.0f - f2;
            BiquadFilter.this.a1 = BiquadFilter.this.b1 = (float)(-2.0 * Math.cos(f));
            BiquadFilter.this.a0 = BiquadFilter.this.b2 = 1.0f + f2;
        }
    }

    private class NotchValCalculator
    extends ValCalculator {
        private NotchValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f2 = (float)Math.sin(f) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b0 = 1.0f;
            BiquadFilter.this.b2 = 1.0f;
            BiquadFilter.this.a1 = BiquadFilter.this.b1 = -2.0f * (float)Math.cos(f);
            BiquadFilter.this.a0 = 1.0f + f2;
            BiquadFilter.this.a2 = 1.0f - f2;
        }
    }

    private class BPPeakValCalculator
    extends ValCalculator {
        private BPPeakValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            BiquadFilter.this.b1 = 0.0f;
            BiquadFilter.this.b0 = (float)Math.sin(f) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b2 = 0.0f - BiquadFilter.this.b0;
            BiquadFilter.this.a0 = 1.0f + BiquadFilter.this.b0;
            BiquadFilter.this.a1 = -2.0f * (float)Math.cos(f);
            BiquadFilter.this.a2 = 1.0f - BiquadFilter.this.b0;
        }
    }

    private class BPSkirtValCalculator
    extends ValCalculator {
        private BPSkirtValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f2 = (float)Math.sin(f);
            float f3 = f2 / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b1 = 0.0f;
            BiquadFilter.this.b0 = f2 * 0.5f;
            BiquadFilter.this.b2 = 0.0f - BiquadFilter.this.b0;
            BiquadFilter.this.a0 = 1.0f + f3;
            BiquadFilter.this.a1 = -2.0f * (float)Math.cos(f);
            BiquadFilter.this.a2 = 1.0f - f3;
        }
    }

    private class HPValCalculator
    extends ValCalculator {
        private HPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f2 = (float)Math.cos(f);
            float f3 = (float)Math.sin(f) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b1 = -1.0f - f2;
            BiquadFilter.this.b2 = BiquadFilter.this.b0 = BiquadFilter.this.b1 * -0.5f;
            BiquadFilter.this.a0 = 1.0f + f3;
            BiquadFilter.this.a1 = -2.0f * f2;
            BiquadFilter.this.a2 = 1.0f - f3;
        }
    }

    private class LPValCalculator
    extends ValCalculator {
        private LPValCalculator() {
        }

        @Override
        public void calcVals() {
            float f = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float f2 = (float)Math.cos(f);
            float f3 = (float)Math.sin(f) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b1 = 1.0f - f2;
            BiquadFilter.this.b2 = BiquadFilter.this.b0 = BiquadFilter.this.b1 * 0.5f;
            BiquadFilter.this.a0 = 1.0f + f3;
            BiquadFilter.this.a1 = -2.0f * f2;
            BiquadFilter.this.a2 = 1.0f - f3;
        }
    }

    protected class ValCalculator {
        protected ValCalculator() {
        }

        public void calcVals() {
        }
    }

    public static enum Type {
        LP,
        HP,
        BP_PEAK,
        BP_SKIRT,
        NOTCH,
        AP,
        PEAKING_EQ,
        LOW_SHELF,
        HIGH_SHELF,
        BUTTERWORTH_LP,
        BUTTERWORTH_HP,
        BESSEL_LP,
        BESSEL_HP,
        CUSTOM_FILTER;

    }
}

