/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public abstract class DelayEvent
extends UGen {
    private long sampleDelay;
    private long count;
    private boolean triggerAfter = false;
    private long threshold;

    public DelayEvent(AudioContext audioContext, double d) {
        this(audioContext, d, false);
    }

    public DelayEvent(AudioContext audioContext, double d, boolean bl) {
        super(audioContext, 0, 0);
        this.sampleDelay = (long)audioContext.msToSamples(d);
        this.reset();
        this.triggeredAfter(bl);
    }

    public void reset() {
        this.count = 0L;
    }

    @Override
    public void calculateBuffer() {
        if (this.sampleDelay - this.count > this.threshold) {
            this.count += (long)this.bufferSize;
        } else {
            this.trigger();
        }
    }

    public abstract void trigger();

    public double getSampleDelay() {
        return this.context.samplesToMs(this.sampleDelay);
    }

    public DelayEvent setSampleDelay(float f) {
        this.sampleDelay = (long)this.context.msToSamples(f);
        return this;
    }

    public double getCount() {
        return this.context.samplesToMs(this.count);
    }

    public boolean isTriggeredAfter() {
        return this.triggerAfter;
    }

    public DelayEvent triggeredAfter(boolean bl) {
        this.triggerAfter = bl;
        this.threshold = bl ? 0L : (long)this.bufferSize;
        return this;
    }
}

