/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class Gain
extends UGen
implements DataBeadReceiver {
    private UGen gainUGen;
    private float gain = 1.0f;

    public Gain(AudioContext audioContext, int n, UGen uGen) {
        super(audioContext, n, n);
        this.setGain(uGen);
    }

    public Gain(AudioContext audioContext, int n, float f) {
        super(audioContext, n, n);
        this.setGain(f);
    }

    public Gain(AudioContext audioContext, int n) {
        this(audioContext, n, 1.0f);
    }

    @Deprecated
    public UGen getGainEnvelope() {
        return this.gainUGen;
    }

    @Deprecated
    public void setGainEnvelope(UGen uGen) {
        this.gainUGen = uGen;
    }

    public float getGain() {
        return this.gain;
    }

    public Gain setGain(float f) {
        this.gainUGen = null;
        this.gain = f;
        return this;
    }

    public Gain setGain(UGen uGen) {
        if (uGen == null) {
            this.setGain(this.gain);
        } else {
            this.gainUGen = uGen;
            uGen.update();
            this.gain = uGen.getValue();
        }
        return this;
    }

    public UGen getGainUGen() {
        return this.gainUGen;
    }

    @Override
    public void calculateBuffer() {
        if (this.gainUGen == null) {
            for (int i = 0; i < this.ins; ++i) {
                float[] fArray = this.bufIn[i];
                float[] fArray2 = this.bufOut[i];
                for (int j = 0; j < this.bufferSize; ++j) {
                    fArray2[j] = this.gain * fArray[j];
                }
            }
        } else {
            this.gainUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.gain = this.gainUGen.getValue(0, i);
                for (int j = 0; j < this.ins; ++j) {
                    this.bufOut[j][i] = this.gain * this.bufIn[j][i];
                }
            }
        }
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            UGen uGen = dataBead.getUGen("gain");
            if (uGen == null) {
                this.setGain(dataBead.getFloat("gain", this.gain));
            } else {
                this.setGain(uGen);
            }
        }
        return this;
    }
}

