/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.ArrayList;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.buffers.CosineWindow;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.Static;

public class GranularSamplePlayer
extends SamplePlayer {
    private UGen pitchEnvelope;
    private UGen grainIntervalEnvelope;
    private UGen grainSizeEnvelope;
    private UGen randomnessEnvelope;
    private UGen randomPanEnvelope;
    private float timeSinceLastGrain;
    private double msPerSample;
    protected float pitch;
    private ArrayList<Grain> grains = new ArrayList();
    private ArrayList<Grain> freeGrains = new ArrayList();
    private ArrayList<Grain> deadGrains = new ArrayList();
    private Buffer window;
    private boolean loopInsideGrains;
    private boolean firstGrain = true;

    public GranularSamplePlayer(AudioContext audioContext, int n) {
        super(audioContext, n);
        this.pitchEnvelope = new Static(audioContext, 1.0f);
        this.setGrainInterval(new Static(audioContext, 70.0f));
        this.setGrainSize(new Static(audioContext, 100.0f));
        this.setRandomness(new Static(audioContext, 0.0f));
        this.setRandomPan(new Static(audioContext, 0.0f));
        this.setWindow(new CosineWindow().getDefault());
        this.msPerSample = audioContext.samplesToMs(1.0);
        this.loopInsideGrains = false;
    }

    public GranularSamplePlayer(AudioContext audioContext, Sample sample) {
        this(audioContext, sample.getNumChannels());
        this.setSample(sample);
        this.loopStartEnvelope = new Static(audioContext, 0.0f);
        this.loopEndEnvelope = new Static(audioContext, (float)sample.getLength());
    }

    @Override
    @Deprecated
    public UGen getPitchEnvelope() {
        return this.pitchEnvelope;
    }

    @Override
    public UGen getPitchUGen() {
        return this.pitchEnvelope;
    }

    @Override
    @Deprecated
    public void setPitchEnvelope(UGen uGen) {
        this.pitchEnvelope = uGen;
    }

    @Override
    public void setPitch(UGen uGen) {
        this.pitchEnvelope = uGen;
    }

    @Deprecated
    public UGen getGrainIntervalEnvelope() {
        return this.grainIntervalEnvelope;
    }

    public UGen getGrainIntervalUGen() {
        return this.grainIntervalEnvelope;
    }

    @Deprecated
    public void setGrainIntervalEnvelope(UGen uGen) {
        this.grainIntervalEnvelope = uGen;
    }

    public void setGrainInterval(UGen uGen) {
        this.grainIntervalEnvelope = uGen;
    }

    @Deprecated
    public UGen getGrainSizeEnvelope() {
        return this.grainSizeEnvelope;
    }

    public UGen getGrainSizeUGen() {
        return this.grainSizeEnvelope;
    }

    @Deprecated
    public void setGrainSizeEnvelope(UGen uGen) {
        this.grainSizeEnvelope = uGen;
    }

    public void setGrainSize(UGen uGen) {
        this.grainSizeEnvelope = uGen;
    }

    public Buffer getWindow() {
        return this.window;
    }

    public void setWindow(Buffer buffer) {
        this.window = buffer;
    }

    @Deprecated
    public UGen getRandomnessEnvelope() {
        return this.randomnessEnvelope;
    }

    public UGen getRandomnessUGen() {
        return this.randomnessEnvelope;
    }

    @Deprecated
    public void setRandomnessEnvelope(UGen uGen) {
        this.randomnessEnvelope = uGen;
    }

    public void setRandomness(UGen uGen) {
        this.randomnessEnvelope = uGen;
    }

    @Deprecated
    public UGen getRandomPanEnvelope() {
        return this.randomPanEnvelope;
    }

    public UGen getRandomPanUGen() {
        return this.randomPanEnvelope;
    }

    @Deprecated
    public void setRandomPanEnvelope(UGen uGen) {
        this.randomPanEnvelope = uGen;
    }

    public void setRandomPan(UGen uGen) {
        this.randomPanEnvelope = uGen;
    }

    @Override
    @Deprecated
    public synchronized void setBuffer(Sample sample) {
        super.setSample(sample);
        this.grains.clear();
        this.timeSinceLastGrain = 0.0f;
    }

    @Override
    public synchronized void setSample(Sample sample) {
        super.setSample(sample);
        this.grains.clear();
        this.timeSinceLastGrain = 0.0f;
    }

    @Override
    public void start() {
        super.start();
        this.timeSinceLastGrain = 0.0f;
    }

    private void resetGrain(Grain grain, int n) {
        grain.position = this.position + (double)(this.grainSizeEnvelope.getValue(0, n) * this.randomnessEnvelope.getValue(0, n)) * (Math.random() * 2.0 - 1.0);
        grain.age = 0.0;
        grain.grainSize = this.grainSizeEnvelope.getValue(0, n);
    }

    private void setGrainPan(Grain grain, float f) {
        grain.pan = new float[this.outs];
        if (this.outs == 2) {
            float f2 = (float)Math.random() * Math.min(1.0f, Math.max(0.0f, f)) * 0.5f;
            f2 = Math.random() < 0.5 ? 0.5f + f2 : 0.5f - f2;
            grain.pan[0] = f2 > 0.5f ? 1.0f : 2.0f * f2;
            grain.pan[1] = f2 < 0.5f ? 1.0f : 2.0f * (1.0f - f2);
        } else {
            for (int i = 0; i < this.outs; ++i) {
                grain.pan[i] = 1.0f;
            }
        }
    }

    private void firstGrain() {
        if (this.firstGrain) {
            Grain grain = new Grain();
            grain.position = this.position;
            grain.age = this.grainSizeEnvelope.getValue() / 4.0f;
            this.grains.add(grain);
            this.firstGrain = false;
            this.timeSinceLastGrain = this.grainIntervalEnvelope.getValue() / 2.0f;
            this.setGrainPan(grain, this.randomPanEnvelope.getValue(0, 0));
        }
    }

    @Override
    public synchronized void calculateBuffer() {
        if (this.sample != null) {
            this.rateEnvelope.update();
            if (this.positionEnvelope != null) {
                this.positionEnvelope.update();
            }
            this.loopStartEnvelope.update();
            this.loopEndEnvelope.update();
            this.pitchEnvelope.update();
            this.grainIntervalEnvelope.update();
            this.grainSizeEnvelope.update();
            this.randomnessEnvelope.update();
            this.randomPanEnvelope.update();
            this.firstGrain();
            for (int i = 0; i < this.bufferSize; ++i) {
                Grain grain;
                int n;
                if (this.timeSinceLastGrain > this.grainIntervalEnvelope.getValue(0, i)) {
                    Grain grain2 = null;
                    if (this.freeGrains.size() > 0) {
                        grain2 = this.freeGrains.get(0);
                        this.freeGrains.remove(0);
                    } else {
                        grain2 = new Grain();
                    }
                    this.resetGrain(grain2, i);
                    this.setGrainPan(grain2, this.randomPanEnvelope.getValue(0, i));
                    this.grains.add(grain2);
                    this.timeSinceLastGrain = 0.0f;
                }
                for (n = 0; n < this.outs; ++n) {
                    this.bufOut[n][i] = 0.0f;
                }
                for (n = 0; n < this.grains.size(); ++n) {
                    grain = this.grains.get(n);
                    float f = this.window.getValueFraction((float)(grain.age / grain.grainSize));
                    switch (this.interpolationType) {
                        case ADAPTIVE: {
                            if (this.pitch > 2.5f) {
                                this.sample.getFrameNoInterp(grain.position, this.frame);
                                break;
                            }
                            if (this.pitch > 0.5f) {
                                this.sample.getFrameLinear(grain.position, this.frame);
                                break;
                            }
                            this.sample.getFrameCubic(grain.position, this.frame);
                            break;
                        }
                        case LINEAR: {
                            this.sample.getFrameLinear(grain.position, this.frame);
                            break;
                        }
                        case CUBIC: {
                            this.sample.getFrameCubic(grain.position, this.frame);
                            break;
                        }
                        case NONE: {
                            this.sample.getFrameNoInterp(grain.position, this.frame);
                        }
                    }
                    for (int j = 0; j < this.outs; ++j) {
                        float[] fArray = this.bufOut[j];
                        int n2 = i;
                        fArray[n2] = fArray[n2] + grain.pan[j] * f * this.frame[j % this.sample.getNumChannels()];
                    }
                }
                this.calculateNextPosition(i);
                this.pitch = Math.abs(this.pitchEnvelope.getValue(0, i));
                for (n = 0; n < this.grains.size(); ++n) {
                    grain = this.grains.get(n);
                    this.calculateNextGrainPosition(grain);
                }
                this.timeSinceLastGrain = (float)((double)this.timeSinceLastGrain + this.msPerSample);
                for (n = 0; n < this.grains.size(); ++n) {
                    grain = this.grains.get(n);
                    if (!(grain.age > grain.grainSize)) continue;
                    this.freeGrains.add(grain);
                    this.deadGrains.add(grain);
                }
                for (n = 0; n < this.deadGrains.size(); ++n) {
                    grain = this.deadGrains.get(n);
                    this.grains.remove(grain);
                }
                this.deadGrains.clear();
            }
        }
    }

    private void calculateNextGrainPosition(Grain grain) {
        int n = this.rate >= 0.0f ? 1 : -1;
        grain.age += this.msPerSample;
        if (this.loopInsideGrains) {
            switch (this.loopType) {
                case NO_LOOP_FORWARDS: {
                    grain.position += (double)n * this.positionIncrement * (double)this.pitch;
                    break;
                }
                case NO_LOOP_BACKWARDS: {
                    grain.position -= (double)n * this.positionIncrement * (double)this.pitch;
                    break;
                }
                case LOOP_FORWARDS: {
                    grain.position += (double)n * this.positionIncrement * (double)this.pitch;
                    if (this.rate > 0.0f && grain.position > (double)Math.max(this.loopStart, this.loopEnd)) {
                        grain.position = Math.min(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(grain.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    grain.position = Math.max(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_BACKWARDS: {
                    grain.position -= (double)n * this.positionIncrement * (double)this.pitch;
                    if (this.rate > 0.0f && grain.position < (double)Math.min(this.loopStart, this.loopEnd)) {
                        grain.position = Math.max(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(grain.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                    grain.position = Math.min(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_ALTERNATING: {
                    grain.position = grain.position + (double)n * (this.forwards ? this.positionIncrement * (double)this.pitch : -this.positionIncrement * (double)this.pitch);
                    if (this.forwards ^ this.rate < 0.0f) {
                        if (!(grain.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                        grain.position = (double)(2.0f * Math.max(this.loopStart, this.loopEnd)) - grain.position;
                        break;
                    }
                    if (!(grain.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    grain.position = (double)(2.0f * Math.min(this.loopStart, this.loopEnd)) - grain.position;
                }
            }
        } else {
            grain.position += (double)n * this.positionIncrement * (double)this.pitch;
        }
    }

    public float getAverageNumberOfGrains() {
        return this.grainSizeEnvelope.getValue() / this.grainIntervalEnvelope.getValue();
    }

    private static class Grain {
        double position;
        double age;
        double grainSize;
        float[] pan;

        private Grain() {
        }
    }
}

