/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public abstract class IIRFilter
extends UGen {
    public IIRFilter(AudioContext audioContext, int n, int n2) {
        super(audioContext, n, n2);
    }

    public abstract IIRFilterAnalysis getFilterResponse(float var1);

    public float getAmplitudeResponse(float f) {
        return (float)this.getFilterResponse((float)f).amplitudeResponse;
    }

    public float getPhaseResponse(float f) {
        return (float)this.getFilterResponse((float)f).phaseResponse;
    }

    public float getPhaseDelay(float f) {
        return (float)this.getFilterResponse((float)f).phaseDelay;
    }

    public float getGroupDelay(float f) {
        return (float)this.getFilterResponse((float)f).groupDelay;
    }

    public static IIRFilterAnalysis calculateFilterResponse(float[] fArray, float[] fArray2, float f, float f2) {
        IIRFilterAnalysis iIRFilterAnalysis = IIRFilter.analyzeFilter(fArray, fArray2, f, f2);
        iIRFilterAnalysis.groupDelay = IIRFilter.calculateGroupDelay(fArray, fArray2, f, f2);
        return iIRFilterAnalysis;
    }

    protected static double calculateGroupDelay(float[] fArray, float[] fArray2, float f, float f2) {
        IIRFilterAnalysis iIRFilterAnalysis = IIRFilter.analyzeFilter(fArray, fArray2, f - 0.01f, f2);
        IIRFilterAnalysis iIRFilterAnalysis2 = IIRFilter.analyzeFilter(fArray, fArray2, f + 0.01f, f2);
        return (iIRFilterAnalysis2.phaseResponse - iIRFilterAnalysis.phaseResponse) / (iIRFilterAnalysis.w - iIRFilterAnalysis2.w);
    }

    protected static IIRFilterAnalysis analyzeFilter(float[] fArray, float[] fArray2, float f, float f2) {
        int n;
        double d = (double)(-2.0f * f) * Math.PI / (double)f2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = 0.0;
        if (fArray.length > 0) {
            d2 = fArray[0];
            for (n = 1; n < fArray.length; ++n) {
                d2 += (double)fArray[n] * Math.cos(d * (double)n);
                d3 += (double)fArray[n] * Math.sin(d * (double)n);
            }
        }
        if (fArray2.length > 0) {
            d4 = fArray2[0];
            for (n = 1; n < fArray2.length; ++n) {
                d4 += (double)fArray2[n] * Math.cos(d * (double)n);
                d5 += (double)fArray2[n] * Math.sin(d * (double)n);
            }
        }
        double d6 = d4 * d4 + d5 * d5;
        IIRFilterAnalysis iIRFilterAnalysis = new IIRFilterAnalysis();
        iIRFilterAnalysis.amplitudeResponse = Math.sqrt((d2 * d2 + d3 * d3) / d6);
        iIRFilterAnalysis.phaseResponse = Math.atan2(d3, d2) - Math.atan2(d5, d4);
        iIRFilterAnalysis.phaseDelay = iIRFilterAnalysis.phaseResponse / Math.PI / -2.0 / (double)f;
        iIRFilterAnalysis.frReal = (d2 * d4 + d3 * d5) / d6;
        iIRFilterAnalysis.frImag = (d3 * d4 - d2 * d5) / d6;
        iIRFilterAnalysis.w = d;
        return iIRFilterAnalysis;
    }

    public static class IIRFilterAnalysis {
        public double frReal = 0.0;
        public double frImag = 0.0;
        public double amplitudeResponse = 0.0;
        public double phaseResponse = 0.0;
        public double phaseDelay = 0.0;
        public double groupDelay = 0.0;
        public double w = 0.0;
    }
}

