/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGenChain;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.AllpassFilter;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.OnePoleFilter;
import net.beadsproject.beads.ugens.RandomPWM;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;

public class Reverb
extends UGenChain
implements DataBeadReceiver {
    private float size;
    private float damping;
    private float earlyLevel;
    private float lateLevel;
    private Gain earlyGain;
    private Gain lateGain;
    private AllpassFilter eAPF1;
    private AllpassFilter eAPF2;
    private AllpassFilter eAPF3;
    private AllpassFilter lAPF1;
    private AllpassFilter lAPF2;
    private AllpassFilter lAPF3;
    private AllpassFilter lAPF4;
    private AllpassFilter[] apfOuts;
    private float[] outDelayScale;
    private OnePoleFilter lpf;
    private OnePoleFilter src;
    private RandomPWM delayModulator;
    private float lateDelay1;
    private float lateDelay2;
    private float lateDelay3;
    private float lateDelay4;
    private float sampsPerMS;
    private TapIn earlyTapIn;
    private TapOut earlyTapOut;

    public Reverb(AudioContext audioContext) {
        this(audioContext, 1);
    }

    public Reverb(AudioContext audioContext, int n) {
        super(audioContext, 1, n);
        this.sampsPerMS = (float)audioContext.msToSamples(1.0);
        this.src = new OnePoleFilter(audioContext, 4000.0f);
        this.earlyTapIn = new TapIn(audioContext, 125.0f);
        this.earlyTapOut = new TapOut(audioContext, this.earlyTapIn, 10.0f);
        this.eAPF1 = new AllpassFilter(audioContext, (int)(12.812 * (double)this.sampsPerMS), 113, 0.3f);
        this.eAPF2 = new AllpassFilter(audioContext, (int)(12.812 * (double)this.sampsPerMS * 3.0), 337, 0.4f);
        this.eAPF3 = new AllpassFilter(audioContext, (int)(12.812 * (double)this.sampsPerMS * 9.4), 1051, 0.5f);
        Gain gain = new Gain(audioContext, 1, -0.3f);
        this.lAPF1 = new AllpassFilter(audioContext, (int)(140.0f * this.sampsPerMS), 19, 0.72f);
        this.lAPF2 = new AllpassFilter(audioContext, (int)(140.0f * this.sampsPerMS), 23, 0.7f);
        this.lAPF3 = new AllpassFilter(audioContext, (int)(140.0f * this.sampsPerMS), 29, 0.65f);
        this.lAPF4 = new AllpassFilter(audioContext, (int)(140.0f * this.sampsPerMS), 37, 0.6f);
        this.lpf = new OnePoleFilter(audioContext, 1000.0f);
        TapIn tapIn = new TapIn(audioContext, 1000.0f);
        TapOut tapOut = new TapOut(audioContext, tapIn, 10.0f);
        TapOut tapOut2 = new TapOut(audioContext, tapIn, 31.17f);
        Gain gain2 = new Gain(audioContext, 1, -0.25f);
        this.earlyGain = new Gain(audioContext, 1, 1.0f);
        this.lateGain = new Gain(audioContext, 1, 1.0f);
        Gain gain3 = new Gain(audioContext, 1, 1.0f);
        this.delayModulator = new RandomPWM(audioContext, RandomPWM.RAMPED_NOISE, 4000.0f, 15000.0f, 1.0f);
        this.drawFromChainInput(this.src);
        this.earlyTapIn.addInput(this.src);
        this.earlyTapIn.addInput(this.earlyGain);
        this.eAPF1.addInput(this.earlyTapOut);
        this.eAPF2.addInput(this.eAPF1);
        this.eAPF3.addInput(this.eAPF2);
        gain.addInput(this.eAPF3);
        this.earlyGain.addInput(gain);
        this.lAPF1.addInput(gain);
        this.lAPF1.addInput(gain2);
        this.lAPF1.addInput(this.src);
        this.lAPF2.addInput(this.lAPF1);
        this.lAPF3.addInput(this.lAPF2);
        this.lAPF4.addInput(this.lAPF3);
        this.lpf.addInput(this.lAPF4);
        tapIn.addInput(this.lpf);
        gain2.addInput(tapOut);
        gain2.addInput(tapOut2);
        this.lateGain.addInput(gain2);
        gain3.addInput(this.earlyGain);
        gain3.addInput(this.lateGain);
        this.apfOuts = new AllpassFilter[n];
        this.outDelayScale = new float[n];
        for (int i = 0; i < n; ++i) {
            float f = 0.3f + (float)i / (float)(i + 1) * 0.1f + (float)Math.sin(i) * 0.05f;
            this.outDelayScale[i] = (3.0f * (float)i + 5.0f) / (5.0f * (float)i + 5.0f);
            this.apfOuts[i] = new AllpassFilter(audioContext, (int)(60.0f * this.sampsPerMS), 20, f);
            this.apfOuts[i].addInput(gain3);
            this.addToChainOutput(i, this.apfOuts[i]);
        }
        this.setSize(0.5f).setDamping(0.7f).setEarlyReflectionsLevel(1.0f).setLateReverbLevel(1.0f);
    }

    @Override
    protected void preFrame() {
        this.delayModulator.update();
        int n = (int)(this.delayModulator.getValue() * 0.3f * this.sampsPerMS);
        this.lAPF1.setDelay((int)this.lateDelay1 - n);
        this.lAPF2.setDelay((int)this.lateDelay2 + n);
        this.lAPF3.setDelay((int)this.lateDelay3 - n);
        this.lAPF4.setDelay((int)this.lateDelay4 + n);
    }

    public float getSize() {
        return this.size;
    }

    public Reverb setSize(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        } else if ((double)f < 0.01) {
            f = 0.01f;
        }
        this.size = f;
        this.lateDelay1 = 86.0f * f * this.sampsPerMS;
        this.lateDelay2 = this.lateDelay1 * 1.16f;
        this.lateDelay3 = this.lateDelay2 * 1.16f;
        this.lateDelay4 = this.lateDelay3 * 1.16f;
        this.earlyTapOut.setDelay(60.0f * f);
        float f2 = 12.812f * this.sampsPerMS * f;
        this.eAPF1.setDelay((int)f2);
        this.eAPF2.setDelay((int)(f2 * 3.0f - 2.0f));
        this.eAPF3.setDelay((int)((double)f2 * 9.3 + 1.0));
        f2 = 60.0f * this.sampsPerMS * f;
        for (int i = 0; i < this.outs; ++i) {
            this.apfOuts[i].setDelay((int)(f2 * this.outDelayScale[i]));
        }
        return this;
    }

    public float getDamping() {
        return this.damping;
    }

    public Reverb setDamping(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.damping = f;
        float f2 = 1.0f - (float)Math.sqrt(f);
        this.src.setFrequency(f2 * 10000.0f + 250.0f);
        this.lpf.setFrequency(f2 * 8000.0f + 200.0f);
        return this;
    }

    public float getEarlyReflectionsLevel() {
        return this.earlyLevel;
    }

    public Reverb setEarlyReflectionsLevel(float f) {
        this.earlyLevel = f;
        this.earlyGain.setGain(f);
        return this;
    }

    public float getLateReverbLevel() {
        return this.lateLevel;
    }

    public Reverb setLateReverbLevel(float f) {
        this.lateLevel = f;
        this.lateGain.setGain(f);
        return this;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            this.setDamping(dataBead.getFloat("damping", this.damping));
            this.setSize(dataBead.getFloat("roomSize", this.size));
            this.setEarlyReflectionsLevel(dataBead.getFloat("earlyReflectionsLevel", this.earlyLevel));
            this.setLateReverbLevel(dataBead.getFloat("lateReverbLevel", this.lateLevel));
        }
        return this;
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("damping", (Object)Float.valueOf(this.damping));
        dataBead.put("roomSize", (Object)Float.valueOf(this.size));
        dataBead.put("earlyReflectionsLevel", (Object)Float.valueOf(this.earlyLevel));
        dataBead.put("lateReverbLevel", (Object)Float.valueOf(this.lateLevel));
        return dataBead;
    }
}

