/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class ZMap
extends UGen
implements DataBeadReceiver {
    private int channels;
    private float a = 1.0f;
    private float b = 0.0f;
    private float o1 = 0.0f;
    private float o2 = 1.0f;
    private float n1 = 0.0f;
    private float n2 = 1.0f;
    private boolean clip = false;
    private boolean flipped = false;

    public ZMap(AudioContext audioContext) {
        this(audioContext, 1);
    }

    public ZMap(AudioContext audioContext, int n) {
        super(audioContext, n, n);
        this.channels = n;
        this.clear();
    }

    @Override
    public void calculateBuffer() {
        for (int i = 0; i < this.channels; ++i) {
            float[] fArray = this.bufIn[i];
            float[] fArray2 = this.bufOut[i];
            if (this.clip) {
                int n;
                if (this.flipped) {
                    for (n = 0; n < this.bufferSize; ++n) {
                        float f = fArray[n];
                        if (f < this.o2) {
                            f = this.o2;
                        } else if (f > this.o1) {
                            f = this.o1;
                        }
                        fArray2[n] = this.a * f + this.b;
                    }
                    continue;
                }
                for (n = 0; n < this.bufferSize; ++n) {
                    float f = fArray[n];
                    if (f > this.o2) {
                        f = this.o2;
                        continue;
                    }
                    if (!(f < this.o1)) continue;
                    f = this.o1;
                    fArray2[n] = this.a * f + this.b;
                }
                continue;
            }
            for (int j = 0; j < this.bufferSize; ++j) {
                fArray2[j] = this.a * fArray[j] + this.b;
            }
        }
    }

    public float getSourceMinimum() {
        return this.o1;
    }

    public ZMap setSourceMinimum(float f) {
        if (f == this.o2) {
            this.o2 = f + 1.0E-10f;
        }
        return this.setRanges(f, this.o2, this.n1, this.n2);
    }

    public float getSourceMaximum() {
        return this.o2;
    }

    public ZMap setSourceMaximun(float f) {
        return this.setRanges(this.o1, f, this.n1, this.n2);
    }

    public float getTargetMinimum() {
        return this.n1;
    }

    public ZMap setTargetMinimum(float f) {
        return this.setRanges(this.o1, this.o2, f, this.n2);
    }

    public float getTargetMaximum() {
        return this.n2;
    }

    public ZMap setTargetMaximum(float f) {
        return this.setRanges(this.o1, this.o2, this.n1, f);
    }

    public ZMap setRanges(float f, float f2, float f3, float f4) {
        if (f == f2) {
            f = f2 - 1.0E-10f;
        }
        this.o1 = f;
        this.o2 = f2;
        this.n1 = f3;
        this.n2 = f4;
        this.flipped = this.o1 > this.o2;
        this.a = (f4 - f3) / (f - f2);
        this.b = f3 - this.a * f;
        return this;
    }

    public ZMap clear() {
        this.o1 = 0.0f;
        this.o2 = 1.0f;
        this.n1 = 0.0f;
        this.n2 = 1.0f;
        this.a = 1.0f;
        this.b = 0.0f;
        this.flipped = false;
        this.clip = false;
        return this;
    }

    public ZMap multiplyThenAdd(float f, float f2) {
        this.a = f;
        this.b = f2;
        this.n1 = this.a * this.o1 + this.b;
        this.n2 = this.a * this.o2 + this.b;
        return this;
    }

    public ZMap addThenMultiply(float f, float f2) {
        return this.multiplyThenAdd(f2, f2 * f);
    }

    public float getMultiplier() {
        return this.a;
    }

    public ZMap setMultiplier(float f) {
        return this.multiplyThenAdd(f, this.b);
    }

    public float getShift() {
        return this.b;
    }

    public ZMap setShift(float f) {
        return this.multiplyThenAdd(this.a, f);
    }

    public boolean getClipping() {
        return this.clip;
    }

    public ZMap setClipping(boolean bl) {
        this.clip = bl;
        return this;
    }

    public int getChannels() {
        return this.channels;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            this.setRanges(dataBead.getFloat("sourceMinimum", this.o1), dataBead.getFloat("sourceMaximum", this.o2), dataBead.getFloat("targetMinimum", this.n1), dataBead.getFloat("targetMaximum", this.n2));
            this.multiplyThenAdd(dataBead.getFloat("multiplier", this.a), dataBead.getFloat("shift", this.b));
            Object object = dataBead.get("clipping");
            if (object instanceof Boolean) {
                this.setClipping((Boolean)object);
            }
        }
        return this;
    }

    public DataBead getParams() {
        return this.getStaticParams();
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("sourceMinimum", (Object)Float.valueOf(this.o1));
        dataBead.put("sourceMaximum", (Object)Float.valueOf(this.o2));
        dataBead.put("targetMinimum", (Object)Float.valueOf(this.n1));
        dataBead.put("targetMaximum", (Object)Float.valueOf(this.n2));
        dataBead.put("multiplier", (Object)Float.valueOf(this.a));
        dataBead.put("shift", (Object)Float.valueOf(this.b));
        dataBead.put("clipping", (Object)this.clip);
        return dataBead;
    }
}

